/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.proxy;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import cofh.core.render.IModelRegister;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.RenderTransport;
import cofh.thermaldynamics.duct.tiles.TileDuctFluid;
import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.proxy.Proxy;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.render.RenderDuctFluids;
import cofh.thermaldynamics.render.RenderDuctItems;
import cofh.thermaldynamics.render.item.RenderItemCover;
import cofh.thermaldynamics.util.TickHandlerClient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyClient
extends Proxy {
    public static EnumBlockRenderType renderType;
    private static List<IModelRegister> modelRegisters;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)TickHandlerClient.INSTANCE);
        ModelRegistryHelper.registerItemRenderer((Item)TDItems.itemCover, (IItemRenderer)RenderItemCover.instance);
        RenderingRegistry.registerEntityRenderingHandler(EntityTransport.class, RenderTransport::new);
        for (IModelRegister register : modelRegisters) {
            register.registerModels();
        }
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        super.initialize(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Basic.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Fast.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.Energy.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctItem.EnergyFast.Transparent.class, (TileEntitySpecialRenderer)RenderDuctItems.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Basic.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Super.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Hardened.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDuctFluid.Energy.Transparent.class, (TileEntitySpecialRenderer)RenderDuctFluids.instance);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        renderType = BlockRenderingRegistry.createRenderType((String)"thermaldynamics");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)renderType, (ICCBlockRenderer)RenderDuct.instance);
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
        TDTextures.registerIcons(event);
        for (int i = 0; i < TDDucts.ductList.size(); ++i) {
            if (!TDDucts.isValid(i)) continue;
            TDDucts.ductList.get(i).registerIcons(event.getMap());
        }
        TDDucts.structureInvis.registerIcons(event.getMap());
    }

    @SubscribeEvent
    public void initializeIcons(TextureStitchEvent.Post event) {
        RenderDuct.initialize();
    }

    @Override
    public boolean addIModelRegister(IModelRegister register) {
        return modelRegisters.add(register);
    }

    static {
        modelRegisters = new ArrayList<IModelRegister>();
    }
}

