/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.init.TDProps;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class ModelHelper {
    static Vector3[] axes = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    static int[] sideMasks = new int[]{3, 3, 12, 12, 48, 48};
    static BlockRenderer.BlockFace face = new BlockRenderer.BlockFace();
    static int[][] orthogonals = new int[][]{{6, 6, 4, 5, 2, 3}, {6, 6, 4, 5, 2, 3}, {4, 5, 6, 6, 0, 1}, {5, 4, 6, 6, 1, 0}, {2, 3, 0, 1, 6, 6}, {3, 2, 1, 0, 6, 6}};
    static int[][] edgePairs = new int[][]{{0, 2}, {0, 3}, {0, 4}, {0, 5}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 4}, {2, 5}, {3, 4}, {3, 5}};
    static int[][] cornerTriplets = new int[][]{{0, 2, 4}, {0, 2, 5}, {0, 3, 4}, {0, 3, 5}, {1, 2, 4}, {1, 2, 5}, {1, 3, 4}, {1, 3, 5}};
    static int[][] orthogAxes = new int[][]{{2, 4}, {2, 4}, {0, 4}, {0, 4}, {0, 2}, {0, 2}};

    public static void finalizeModel(CCModel model1) {
        ModelHelper.finalizeModel(model1, true);
    }

    public static void finalizeModel(CCModel model1, boolean lighting) {
        if (lighting) {
            model1.shrinkUVs(9.765625E-4).computeNormals().computeLighting(LightModel.standardLightModel);
        } else {
            model1.shrinkUVs(9.765625E-4).computeNormals();
        }
    }

    public static CCModel expandModel(CCModel model, double size) {
        return ModelHelper.expandModel(model, new Cuboid6(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), size);
    }

    public static CCModel expandModel(CCModel model, Cuboid6 bounds, double size) {
        CCModel newModel = CCModel.newModel((int)(model.vp == 4 ? 7 : 3), (int)model.verts.length);
        for (Vertex5 v : newModel.verts = (Vertex5[])model.verts.clone()) {
            v.vec.multiply(size);
            if (v.vec.x < bounds.min.x) {
                v.vec.x = bounds.min.x;
            }
            if (v.vec.y < bounds.min.y) {
                v.vec.y = bounds.min.y;
            }
            if (v.vec.z < bounds.min.z) {
                v.vec.z = bounds.min.z;
            }
            if (v.vec.x > bounds.max.x) {
                v.vec.x = bounds.max.x;
            }
            if (v.vec.y > bounds.max.y) {
                v.vec.y = bounds.max.y;
            }
            if (!(v.vec.z > bounds.max.z)) continue;
            v.vec.z = bounds.max.z;
        }
        return newModel.computeNormals();
    }

    public static void addSideFaces(LinkedList<Vertex5> vecs, Cuboid6 bounds, int sideMask) {
        for (int s = 0; s < 6; ++s) {
            if ((sideMask & 1 << s) != 0) continue;
            ModelHelper.addSideFace(vecs, bounds, s);
        }
    }

    public static LinkedList<Vertex5> addSideFace(LinkedList<Vertex5> vecs, Cuboid6 bounds, int side) {
        face.loadCuboidFace(bounds.copy().add(Vector3.center), side);
        for (Vertex5 v : face.getVertices()) {
            vecs.add(new Vertex5(v.vec.copy().sub(Vector3.center), v.uv.copy()));
        }
        return vecs;
    }

    public static LinkedList<Vertex5> apply(LinkedList<Vertex5> vecs, Transformation transformation) {
        LinkedList<Vertex5> t = new LinkedList<Vertex5>();
        for (Vertex5 v : vecs) {
            t.add(v.copy().apply(transformation));
        }
        return t;
    }

    public static LinkedList<Vertex5> simplifyModel(LinkedList<Vertex5> in) {
        LinkedList<Face> faces = new LinkedList<Face>();
        Iterator<Vertex5> iter = in.iterator();
        while (iter.hasNext()) {
            Face f = Face.loadFromIterator(iter);
            faces.removeIf(f::attemptToCombine);
            faces.add(f);
        }
        LinkedList<Vertex5> out = new LinkedList<Vertex5>();
        for (Face f : faces) {
            Collections.addAll(out, f.verts);
        }
        return out;
    }

    public static class SideTubeGen {
        public double s;
        public double s2;
        public double h = 1.0;
        public static CCModel[] standardTubes = new SideTubeGen(0.1876).generateModels();
        public static CCModel[] standardTubesInner = new SideTubeGen(0.1876).contract(0.999).generateModels();

        public SideTubeGen(double s) {
            this(s, s + 0.09375);
        }

        public SideTubeGen(double s, double s2) {
            this.s = s;
            this.s2 = s2;
        }

        public SideTubeGen contract(double h) {
            this.h = h;
            return this;
        }

        public Cuboid6 newCube(Vector3 min, Vector3 max) {
            double temp;
            if (min.x > max.x) {
                temp = min.x;
                min.x = max.x;
                max.x = temp;
            }
            if (min.y > max.y) {
                temp = min.y;
                min.y = max.y;
                max.y = temp;
            }
            if (min.z > max.z) {
                temp = min.z;
                min.z = max.z;
                max.z = temp;
            }
            if (this.h < 1.0) {
                Vector3 mid = min.copy().add(max).multiply(0.5);
                min.x = min.x <= -0.5 || min.x >= 0.5 ? min.x : (min.x - mid.x) * this.h + mid.x;
                min.y = min.y <= -0.5 || min.y >= 0.5 ? min.y : (min.y - mid.y) * this.h + mid.y;
                min.z = min.z <= -0.5 || min.z >= 0.5 ? min.z : (min.z - mid.z) * this.h + mid.z;
                max.x = max.x <= -0.5 || max.x >= 0.5 ? max.x : (max.x - mid.x) * this.h + mid.x;
                max.y = max.y <= -0.5 || max.y >= 0.5 ? max.y : (max.y - mid.y) * this.h + mid.y;
                max.z = max.z <= -0.5 || max.z >= 0.5 ? max.z : (max.z - mid.z) * this.h + mid.z;
            }
            return new Cuboid6(min, max);
        }

        private LinkedList<Vertex5> generateConnections(int i) {
            Cuboid6 cube;
            LinkedList<Vertex5> vecs = new LinkedList<Vertex5>();
            Vector3 a = axes[i];
            Vector3 b = axes[orthogAxes[i][0]];
            Vector3 c = axes[orthogAxes[i][1]];
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    cube = this.newCube(a.copy().multiply(this.s2).add(b.copy().multiply(this.s * (double)x)).add(c.copy().multiply(this.s * (double)y)), a.copy().multiply(this.h / 2.0).add(b.copy().multiply(this.s2 * (double)x)).add(c.copy().multiply(this.s2 * (double)y)));
                    ModelHelper.addSideFaces(vecs, cube, 1 << i ^ 0x3F);
                }
            }
            for (int j = 0; j < 6; ++j) {
                if (i == j || (i ^ 1) == j) continue;
                a = axes[i];
                b = axes[j];
                int orthog = orthogonals[i][j];
                c = axes[orthog];
                cube = this.newCube(a.copy().multiply(this.h / 2.0 - (this.s2 - this.s)).add(b.copy().multiply(this.s)).add(c.copy().multiply(this.s)), a.copy().multiply(this.h / 2.0).add(b.copy().multiply(this.s2)).add(c.copy().multiply(-this.s)));
                ModelHelper.addSideFaces(vecs, cube, 1 << orthog | 1 << (orthog ^ 1));
            }
            return vecs;
        }

        private LinkedList<Vertex5> generateIntersections(int connections) {
            Cuboid6 cube;
            Vector3 c;
            Vector3 b;
            Vector3 a;
            LinkedList<Vertex5> vecs = new LinkedList<Vertex5>();
            boolean cullSides = false;
            for (int i = 0; i < 6; ++i) {
                if ((connections & 1 << i) == 0) continue;
                a = axes[i];
                b = axes[orthogAxes[i][0]];
                c = axes[orthogAxes[i][1]];
                for (int x = -1; x <= 1; x += 2) {
                    for (int y = -1; y <= 1; y += 2) {
                        cube = this.newCube(a.copy().multiply(this.s2).add(b.copy().multiply(this.s * (double)x)).add(c.copy().multiply(this.s * (double)y)), a.copy().multiply(this.h / 2.0).add(b.copy().multiply(this.s2 * (double)x)).add(c.copy().multiply(this.s2 * (double)y)));
                        ModelHelper.addSideFaces(vecs, cube, 1 << i | 1 << (i ^ 1));
                    }
                }
            }
            for (int[] pair : edgePairs) {
                if (!cullSides && (connections & 1 << pair[0]) != 0 != ((connections & 1 << pair[1]) != 0)) continue;
                a = axes[pair[0]];
                b = axes[pair[1]];
                int orthog = orthogonals[pair[0]][pair[1]];
                c = axes[orthog];
                cube = this.newCube(a.copy().multiply(this.s).add(b.copy().multiply(this.s)).add(c.copy().multiply(this.s)), a.copy().multiply(this.s2).add(b.copy().multiply(this.s2)).add(c.copy().multiply(-this.s)));
                ModelHelper.addSideFaces(vecs, cube, 1 << orthog | 1 << (orthog ^ 1));
            }
            for (int[] cr : cornerTriplets) {
                a = axes[cr[0]];
                b = axes[cr[1]];
                c = axes[cr[2]];
                cube = this.newCube(a.copy().multiply(this.s).add(b.copy().multiply(this.s)).add(c.copy().multiply(this.s)), a.copy().multiply(this.s2).add(b.copy().multiply(this.s2)).add(c.copy().multiply(this.s2)));
                int m = 1 << cr[0] & connections | 1 << cr[1] & connections | 1 << cr[2] & connections;
                if (cullSides || (connections & 1 << cr[1]) != 0 == ((connections & 1 << cr[2]) != 0)) {
                    m |= 1 << (cr[0] ^ 1);
                }
                if (cullSides || (connections & 1 << cr[0]) != 0 == ((connections & 1 << cr[2]) != 0)) {
                    m |= 1 << (cr[1] ^ 1);
                }
                if (cullSides || (connections & 1 << cr[0]) != 0 == ((connections & 1 << cr[1]) != 0)) {
                    m |= 1 << (cr[2] ^ 1);
                }
                ModelHelper.addSideFaces(vecs, cube, m);
            }
            return vecs;
        }

        public CCModel[] generateModels() {
            Vertex5 nv;
            int j;
            int n;
            LinkedList<Vertex5> v;
            int i;
            CCModel[] models = new CCModel[70];
            for (i = 0; i < 64; ++i) {
                v = this.generateIntersections(i);
                v = ModelHelper.simplifyModel(v);
                n = v.size();
                models[i] = CCModel.newModel((int)7, (int)(n * 2));
                for (j = 0; j < n; ++j) {
                    models[i].verts[j] = nv = v.get(j);
                }
                CCModel.generateBackface((CCModel)models[i], (int)0, (CCModel)models[i], (int)n, (int)n);
                ModelHelper.finalizeModel(models[i]);
            }
            for (i = 0; i < 6; ++i) {
                v = this.generateConnections(i);
                v = ModelHelper.simplifyModel(v);
                n = v.size();
                models[64 + i] = CCModel.newModel((int)7, (int)n);
                for (j = 0; j < n; ++j) {
                    models[64 + i].verts[j] = nv = v.get(j);
                }
                ModelHelper.finalizeModel(models[64 + i]);
            }
            return models;
        }
    }

    public static class OctagonalTubeGen {
        double size;
        double innerSize;
        static final double outerWidth = 0.5;
        boolean frameOnly = false;
        Vector3[] octoFace;

        public OctagonalTubeGen(double size, boolean framesOnly) {
            this(size, size * 0.414, framesOnly);
        }

        public static int getBestSide(Vector3 vector3) {
            int s = 0;
            double m = 0.0;
            for (int i = 2; i < 6; ++i) {
                if (!(Math.abs(vector3.getSide(i)) > m)) continue;
                m = Math.abs(vector3.getSide(i));
                s = i;
            }
            return s;
        }

        public static Vertex5 toVertex5(Vector3 vector3) {
            return OctagonalTubeGen.toVertex5(vector3, OctagonalTubeGen.getBestSide(vector3));
        }

        public static Vertex5 toVertex5(Vector3 vector3, int side) {
            UV uv = side == 0 || side == 1 ? new UV(0.5 + vector3.x, 0.5 + vector3.z) : (side == 2 || side == 3 ? new UV(0.5 + vector3.x, 0.5 + vector3.y) : (side == 4 || side == 5 ? new UV(0.5 + vector3.z, 0.5 + vector3.y) : new UV(0.5, 0.5)));
            return new Vertex5(vector3, uv);
        }

        public OctagonalTubeGen(double s, double t, boolean framesOnly) {
            this.size = s;
            this.innerSize = t;
            this.frameOnly = framesOnly;
            this.octoFace = new Vector3[8];
            this.octoFace[0] = new Vector3(-s, -0.5, -t);
            this.octoFace[1] = new Vector3(-t, -0.5, -s);
            this.octoFace[2] = new Vector3(t, -0.5, -s);
            this.octoFace[3] = new Vector3(s, -0.5, -t);
            this.octoFace[4] = new Vector3(s, -0.5, t);
            this.octoFace[5] = new Vector3(t, -0.5, s);
            this.octoFace[6] = new Vector3(-t, -0.5, s);
            this.octoFace[7] = new Vector3(-s, -0.5, t);
        }

        public CCModel generateSideFace() {
            CCModel model = CCModel.newModel((int)7, (int)24);
            model.verts[0] = OctagonalTubeGen.toVertex5(this.octoFace[0].copy(), 0);
            model.verts[1] = OctagonalTubeGen.toVertex5(this.octoFace[1].copy(), 0);
            model.verts[2] = OctagonalTubeGen.toVertex5(this.octoFace[2].copy(), 0);
            model.verts[3] = OctagonalTubeGen.toVertex5(this.octoFace[3].copy(), 0);
            model.verts[4] = OctagonalTubeGen.toVertex5(this.octoFace[4].copy(), 0);
            model.verts[5] = OctagonalTubeGen.toVertex5(this.octoFace[5].copy(), 0);
            model.verts[6] = OctagonalTubeGen.toVertex5(this.octoFace[6].copy(), 0);
            model.verts[7] = OctagonalTubeGen.toVertex5(this.octoFace[7].copy(), 0);
            model.verts[8] = OctagonalTubeGen.toVertex5(this.octoFace[0].copy(), 0);
            model.verts[9] = OctagonalTubeGen.toVertex5(this.octoFace[3].copy(), 0);
            model.verts[10] = OctagonalTubeGen.toVertex5(this.octoFace[4].copy(), 0);
            model.verts[11] = OctagonalTubeGen.toVertex5(this.octoFace[7].copy(), 0);
            for (int i = 0; i < 12; ++i) {
                model.verts[i].vec.y = -0.5 * (this.frameOnly ? 0.75 : 0.99);
            }
            CCModel.generateBackface((CCModel)model, (int)0, (CCModel)model, (int)12, (int)12);
            return model;
        }

        public CCModel generateConnection() {
            CCModel model = CCModel.newModel((int)7, (int)64);
            double v = 0.375 * (double)TDProps.largeInnerModelScaling;
            double o = 1.01;
            for (int k = 0; k < 8; ++k) {
                model.verts[k * 4] = new Vertex5(this.octoFace[k].copy().multiply(o, 1.0, o), 0.5 - this.innerSize, 0.0);
                model.verts[k * 4 + 1] = new Vertex5(this.octoFace[k].copy().multiply(o, 1.0, o).setSide(0, -v), 0.5 - this.innerSize, 0.5 - v);
                model.verts[k * 4 + 2] = new Vertex5(this.octoFace[(k + 1) % 8].copy().multiply(o, 1.0, o).setSide(0, -v), 0.5 + this.innerSize, 0.5 - v);
                model.verts[k * 4 + 3] = new Vertex5(this.octoFace[(k + 1) % 8].copy().multiply(o, 1.0, o), 0.5 + this.innerSize, 0.0);
            }
            CCModel.generateBackface((CCModel)model, (int)0, (CCModel)model, (int)32, (int)32);
            return model;
        }

        public CCModel[] generateModels() {
            int s;
            CCModel[] models = new CCModel[76];
            for (int i = 0; i < 64; ++i) {
                LinkedList<Vertex5> v = this.generateIntersections(i);
                v = ModelHelper.simplifyModel(v);
                int n = v.size();
                models[i] = CCModel.newModel((int)7, (int)(n * 2));
                for (int j = 0; j < n; ++j) {
                    Vertex5 nv;
                    models[i].verts[j] = nv = v.get(j);
                }
                CCModel.generateBackface((CCModel)models[i], (int)0, (CCModel)models[i], (int)n, (int)n);
                ModelHelper.finalizeModel(models[i]);
            }
            models[64] = this.generateConnection();
            for (s = 0; s < 6; ++s) {
                if (s != 0) {
                    models[64 + s] = models[64].sidedCopy(0, s, Vector3.zero);
                }
                ModelHelper.finalizeModel(models[64 + s]);
            }
            models[70] = this.generateSideFace();
            for (s = 0; s < 6; ++s) {
                if (s != 0) {
                    models[70 + s] = models[70].sidedCopy(0, s, Vector3.zero);
                }
                ModelHelper.finalizeModel(models[70 + s]);
            }
            return models;
        }

        public LinkedList<Vertex5> generateIntersections(int connections) {
            int j;
            int i;
            LinkedList<Vertex5> v = new LinkedList<Vertex5>();
            LinkedList<Vertex5> center = ModelHelper.addSideFace(new LinkedList<Vertex5>(), new Cuboid6(-this.innerSize, -this.size, -this.innerSize, this.innerSize, this.size, this.innerSize), 0);
            LinkedList<Vertex5> arm = new LinkedList<Vertex5>();
            for (int k = 0; k < 8; ++k) {
                if (this.frameOnly && k % 2 == 0) continue;
                arm.add(OctagonalTubeGen.toVertex5(this.octoFace[k].copy()));
                arm.add(OctagonalTubeGen.toVertex5(this.octoFace[k].copy().setSide(0, -this.size)));
                arm.add(OctagonalTubeGen.toVertex5(this.octoFace[(k + 1) % 8].copy().setSide(0, -this.size)));
                arm.add(OctagonalTubeGen.toVertex5(this.octoFace[(k + 1) % 8].copy()));
            }
            for (i = 0; i < 6; ++i) {
                if ((connections & 1 << i) != 0) {
                    v.addAll(ModelHelper.apply(arm, Rotation.sideRotations[i]));
                    continue;
                }
                v.addAll(ModelHelper.apply(center, Rotation.sideRotations[i]));
            }
            for (i = 0; i < 6; ++i) {
                for (j = i + 1; j < 6; ++j) {
                    if ((i ^ 1) == j) continue;
                    boolean a = (connections & 1 << i) != 0;
                    boolean b = (connections & 1 << j) != 0;
                    Vector3 v1 = axes[i].copy();
                    Vector3 v2 = axes[j].copy();
                    Vector3 v3 = v1.copy().crossProduct(v2);
                    if (!a && !b) {
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.innerSize)).add(v3.copy().multiply(this.innerSize)), i));
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.innerSize)).add(v3.copy().multiply(-this.innerSize)), i));
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(-this.innerSize)), i));
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(this.innerSize)), i));
                        continue;
                    }
                    if (!a && b) {
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.innerSize)).add(v3.copy().multiply(this.innerSize)), i));
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.innerSize)).add(v3.copy().multiply(-this.innerSize)), i));
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(-this.innerSize)), i));
                        v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(this.innerSize)), i));
                        continue;
                    }
                    if (!a || b) continue;
                    v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(this.innerSize)), j));
                    v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.size).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(-this.innerSize)), j));
                    v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(-this.innerSize)), j));
                    v.add(OctagonalTubeGen.toVertex5(v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.size)).add(v3.copy().multiply(this.innerSize)), j));
                }
            }
            if (!this.frameOnly) {
                for (i = 0; i < 2; ++i) {
                    for (j = 2; j < 4; ++j) {
                        for (int k = 4; k < 6; ++k) {
                            Vector3 a3;
                            Vector3 a2;
                            Vector3 a1;
                            int dir;
                            Vector3 a32;
                            Vector3 a22;
                            boolean up = (connections & 1 << i) != 0;
                            boolean right = (connections & 1 << j) != 0;
                            boolean left = (connections & 1 << k) != 0;
                            int s = (up ? 1 : 0) + (right ? 1 : 0) + (left ? 1 : 0);
                            Vector3 v1 = axes[i];
                            Vector3 v2 = axes[j];
                            Vector3 v3 = axes[k];
                            if (s == 3) {
                                Vector3 a12 = v1.copy().multiply(this.size).add(v2.copy().multiply(this.size).add(v3.copy().multiply(this.innerSize)));
                                a22 = v1.copy().multiply(this.size).add(v2.copy().multiply(this.innerSize).add(v3.copy().multiply(this.size)));
                                a32 = v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.size).add(v3.copy().multiply(this.size)));
                                v.add(OctagonalTubeGen.toVertex5(a12, i));
                                v.add(OctagonalTubeGen.toVertex5(a32, i));
                                v.add(OctagonalTubeGen.toVertex5(a22, i));
                                v.add(OctagonalTubeGen.toVertex5(a12, i));
                                continue;
                            }
                            if (s == 0) {
                                Vector3 a13 = v1.copy().multiply(this.size).add(v2.copy().multiply(this.innerSize).add(v3.copy().multiply(this.innerSize)));
                                a22 = v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.innerSize).add(v3.copy().multiply(this.size)));
                                a32 = v1.copy().multiply(this.innerSize).add(v2.copy().multiply(this.size).add(v3.copy().multiply(this.innerSize)));
                                v.add(OctagonalTubeGen.toVertex5(a13, 0));
                                v.add(OctagonalTubeGen.toVertex5(a32, 0));
                                v.add(OctagonalTubeGen.toVertex5(a22, 0));
                                v.add(OctagonalTubeGen.toVertex5(a13, 0));
                                continue;
                            }
                            if (s == 1) {
                                Vector3 a14;
                                if (up) {
                                    a14 = v1;
                                    a22 = v2;
                                    a32 = v3;
                                } else if (right) {
                                    a14 = v2;
                                    a22 = v1;
                                    a32 = v3;
                                } else {
                                    a14 = v3;
                                    a22 = v1;
                                    a32 = v2;
                                }
                                v.add(OctagonalTubeGen.toVertex5(a14.copy().multiply(this.innerSize).add(a22.copy().multiply(this.size)).add(a32.copy().multiply(this.innerSize)), 0));
                                v.add(OctagonalTubeGen.toVertex5(a14.copy().multiply(this.size).add(a22.copy().multiply(this.size).add(a32.copy().multiply(this.innerSize))), 0));
                                v.add(OctagonalTubeGen.toVertex5(a14.copy().multiply(this.size).add(a22.copy().multiply(this.innerSize)).add(a32.copy().multiply(this.size)), 0));
                                v.add(OctagonalTubeGen.toVertex5(a14.copy().multiply(this.innerSize).add(a22.copy().multiply(this.innerSize)).add(a32.copy().multiply(this.size)), 0));
                                continue;
                            }
                            if (s != 2) continue;
                            if (!up) {
                                dir = i;
                                a1 = v1;
                                a2 = v2;
                                a3 = v3;
                            } else if (!right) {
                                dir = j;
                                a1 = v2;
                                a2 = v1;
                                a3 = v3;
                            } else {
                                dir = k;
                                a1 = v3;
                                a2 = v1;
                                a3 = v2;
                            }
                            v.add(OctagonalTubeGen.toVertex5(a1.copy().multiply(this.size).add(a2.copy().multiply(this.innerSize)).add(a3.copy().multiply(this.innerSize)), dir));
                            v.add(OctagonalTubeGen.toVertex5(a1.copy().multiply(this.size).add(a2.copy().multiply(this.size)).add(a3.copy().multiply(this.innerSize)), dir));
                            v.add(OctagonalTubeGen.toVertex5(a1.copy().multiply(this.innerSize).add(a2.copy().multiply(this.size)).add(a3.copy().multiply(this.size)), dir));
                            v.add(OctagonalTubeGen.toVertex5(a1.copy().multiply(this.size).add(a2.copy().multiply(this.innerSize)).add(a3.copy().multiply(this.size)), dir));
                        }
                    }
                }
            }
            return v;
        }
    }

    public static class Face {
        public Vertex5[] verts;

        public static Face loadFromIterator(Iterator<Vertex5> iter) {
            Face f = new Face(new Vertex5[4]);
            for (int i = 0; i < 4; ++i) {
                f.verts[i] = iter.next();
            }
            return f;
        }

        public Vertex5 vec(int s) {
            return this.verts[s & 3];
        }

        public void setVec(int s, Vertex5 newVec) {
            this.verts[s & 3] = newVec;
        }

        public Face(Vertex5 ... v) {
            assert (v.length == 4);
            this.verts = v;
        }

        public boolean isPolygon() {
            for (int i = 0; i < 4; ++i) {
                if (!this.vec((int)i).vec.equalsT(this.vec((int)(i + 1)).vec)) continue;
                return true;
            }
            return false;
        }

        public Face reverse() {
            this.verts = new Vertex5[]{this.verts[3], this.verts[2], this.verts[1], this.verts[0]};
            return this;
        }

        public boolean attemptToCombine(Face other) {
            if (this.isPolygon() || other.isPolygon()) {
                return false;
            }
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            other.reverse();
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            if (this.attemptToCombineUnflipped(other)) {
                return true;
            }
            this.reverse();
            other.reverse();
            return false;
        }

        public boolean equalVert(Vertex5 a, Vertex5 b) {
            return a.vec.equalsT(b.vec) && a.uv.equals((Object)b.uv);
        }

        public boolean attemptToCombineUnflipped(Face other) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!this.equalVert(this.vec(i), this.vec(j)) || !this.equalVert(this.vec(i + 1), this.vec(j - 1))) continue;
                    Vector3 l1 = this.vec((int)(i - 1)).vec.copy().subtract(this.vec((int)i).vec).normalize();
                    Vector3 l2 = this.vec((int)(i + 2)).vec.copy().subtract(this.vec((int)(i + 1)).vec).normalize();
                    Vector3 l3 = other.vec((int)j).vec.copy().subtract(other.vec((int)(j + 1)).vec).normalize();
                    Vector3 l4 = other.vec((int)(j - 1)).vec.copy().subtract(other.vec((int)(j - 2)).vec).normalize();
                    if (!l1.equalsT(l3) || !l2.equalsT(l4)) continue;
                    this.setVec(i, other.vec(j + 1));
                    this.setVec(i + 1, other.vec(j - 2));
                    return true;
                }
            }
            return false;
        }
    }

    public static class StandardTubes {
        public final boolean opaque;
        public final float width;
        static final int[][] orthogs = new int[][]{{2, 3, 4, 5}, {2, 3, 4, 5}, {0, 1, 4, 5}, {0, 1, 4, 5}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        Cuboid6 center;
        Cuboid6[] ductWCenter = new Cuboid6[6];
        Cuboid6[] duct = new Cuboid6[6];
        Cuboid6[] ductFullLength = new Cuboid6[6];

        public static Cuboid6[] rotateCuboids(Cuboid6 downCube) {
            Cuboid6[] cuboid6s = new Cuboid6[6];
            for (int i = 0; i < 6; ++i) {
                cuboid6s[i] = downCube.copy().apply(Rotation.sideRotations[i]);
            }
            return cuboid6s;
        }

        public static CCModel[] genModels(float w, boolean opaque) {
            return StandardTubes.genModels(w, opaque, true);
        }

        public static CCModel[] genModels(float w, boolean opaque, boolean lighting) {
            StandardTubes tubes = new StandardTubes(w, opaque);
            CCModel[] models = new CCModel[64];
            for (int i = 0; i < 64; ++i) {
                LinkedList<Vertex5> model = tubes.createModel(i);
                int n = model.size();
                models[i] = CCModel.newModel((int)7, (int)(n * 2));
                for (int j = 0; j < n; ++j) {
                    models[i].verts[j] = model.get(j);
                }
                CCModel.generateBackface((CCModel)models[i], (int)0, (CCModel)models[i], (int)n, (int)n);
                ModelHelper.finalizeModel(models[i], lighting);
            }
            return models;
        }

        public StandardTubes(int i) {
            this.width = 0.36f;
            this.opaque = false;
            double d1 = 0.47 - 0.025 * (double)i;
            double d2 = 0.53 + 0.025 * (double)i;
            double d3 = 0.32 + 0.06 * (double)i;
            double c1 = 0.32;
            double c2 = 0.68;
            double[][] boxes = new double[][]{{d1, 0.0, d1, d2, c1, d2}, {d1, d3, d1, d2, 1.0, d2}, {c1, c1, 0.0, c2, d3, c1}, {c1, c1, c2, c2, d3, 1.0}, {0.0, c1, c1, c1, d3, c2}, {c2, c1, c1, 1.0, d3, c2}};
            this.center = new Cuboid6(c1, c1, c1, c2, d3, c2);
            this.duct = new Cuboid6[6];
            for (int s = 0; s < this.duct.length; ++s) {
                this.duct[s] = new Cuboid6(boxes[s][0], boxes[s][1], boxes[s][2], boxes[s][3], boxes[s][4], boxes[s][5]);
            }
        }

        public StandardTubes(float w, boolean opaque) {
            this.width = w;
            this.center = new Cuboid6((double)(-w), (double)(-w), (double)(-w), (double)w, (double)w, (double)w);
            this.duct = StandardTubes.rotateCuboids(new Cuboid6((double)(-w), -0.5, (double)(-w), (double)w, (double)(-w), (double)w));
            this.ductWCenter = StandardTubes.rotateCuboids(new Cuboid6((double)(-w), -0.5, (double)(-w), (double)w, (double)w, (double)w));
            this.ductFullLength = StandardTubes.rotateCuboids(new Cuboid6((double)(-w), -0.5, (double)(-w), (double)w, 0.5, (double)w));
            this.opaque = opaque;
        }

        public LinkedList<Vertex5> createModel(int cMask) {
            LinkedList<Vertex5> verts = new LinkedList<Vertex5>();
            for (int side = 0; side < 6; ++side) {
                if (!this.opaque && MathHelper.isBitSet((int)cMask, (int)side)) {
                    for (int i : orthogs[side]) {
                        if (!MathHelper.isBitSet((int)cMask, (int)i)) continue;
                        ModelHelper.addSideFace(verts, this.duct[i], side);
                    }
                    continue;
                }
                int singlePipeIndex = -1;
                int doublePipeIndex = -1;
                for (int i : orthogs[side]) {
                    if (!MathHelper.isBitSet((int)cMask, (int)i) || this.ductWCenter[i] == null) continue;
                    singlePipeIndex = i;
                    if (!MathHelper.isBitSet((int)cMask, (int)(i ^ 1)) || this.ductFullLength[i] == null || this.ductFullLength[i ^ 1] == null) continue;
                    doublePipeIndex = i;
                    break;
                }
                if (doublePipeIndex != -1) {
                    for (int i : orthogs[side]) {
                        if (i == doublePipeIndex) {
                            ModelHelper.addSideFace(verts, this.ductFullLength[i], side);
                            continue;
                        }
                        if (i == (doublePipeIndex ^ 1) || !MathHelper.isBitSet((int)cMask, (int)i)) continue;
                        ModelHelper.addSideFace(verts, this.duct[i], side);
                    }
                    continue;
                }
                if (singlePipeIndex != -1) {
                    for (int i : orthogs[side]) {
                        if (i == singlePipeIndex) {
                            ModelHelper.addSideFace(verts, this.ductWCenter[i], side);
                            continue;
                        }
                        if (!MathHelper.isBitSet((int)cMask, (int)i)) continue;
                        ModelHelper.addSideFace(verts, this.duct[i], side);
                    }
                    continue;
                }
                if (!MathHelper.isBitSet((int)cMask, (int)side)) {
                    ModelHelper.addSideFace(verts, this.center, side);
                }
                for (int i : orthogs[side]) {
                    if (!MathHelper.isBitSet((int)cMask, (int)i)) continue;
                    ModelHelper.addSideFace(verts, this.duct[i], side);
                }
            }
            return verts;
        }
    }
}

