/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bittank;

import mod.chiselsandbits.bittank.FluidModelVertex;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRenderBitTank
extends FastTESR<TileEntityBitTank> {
    private final FluidModelVertex[] model = new FluidModelVertex[24];

    public TileEntitySpecialRenderBitTank() {
        this.model[0] = new FluidModelVertex(EnumFacing.UP, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.model[1] = new FluidModelVertex(EnumFacing.UP, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        this.model[2] = new FluidModelVertex(EnumFacing.UP, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0);
        this.model[3] = new FluidModelVertex(EnumFacing.UP, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0);
        this.model[4] = new FluidModelVertex(EnumFacing.DOWN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.model[5] = new FluidModelVertex(EnumFacing.DOWN, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        this.model[6] = new FluidModelVertex(EnumFacing.DOWN, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0);
        this.model[7] = new FluidModelVertex(EnumFacing.DOWN, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0);
        this.model[8] = new FluidModelVertex(EnumFacing.NORTH, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.model[9] = new FluidModelVertex(EnumFacing.NORTH, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        this.model[10] = new FluidModelVertex(EnumFacing.NORTH, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0);
        this.model[11] = new FluidModelVertex(EnumFacing.NORTH, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.model[12] = new FluidModelVertex(EnumFacing.SOUTH, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
        this.model[13] = new FluidModelVertex(EnumFacing.SOUTH, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        this.model[14] = new FluidModelVertex(EnumFacing.SOUTH, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0);
        this.model[15] = new FluidModelVertex(EnumFacing.SOUTH, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.model[16] = new FluidModelVertex(EnumFacing.EAST, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.model[17] = new FluidModelVertex(EnumFacing.EAST, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        this.model[18] = new FluidModelVertex(EnumFacing.EAST, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0);
        this.model[19] = new FluidModelVertex(EnumFacing.EAST, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.model[20] = new FluidModelVertex(EnumFacing.WEST, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.model[21] = new FluidModelVertex(EnumFacing.WEST, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        this.model[22] = new FluidModelVertex(EnumFacing.WEST, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0);
        this.model[23] = new FluidModelVertex(EnumFacing.WEST, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public void renderTileEntityFast(TileEntityBitTank te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer worldRenderer) {
        if (destroyStage > 0) {
            return;
        }
        FluidStack fluidStack = te.getBitsAsFluidStack();
        if (fluidStack != null) {
            int pass;
            Fluid fluid = fluidStack.getFluid();
            int n = pass = fluid.getBlock().func_180664_k() == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
            if (MinecraftForgeClient.getRenderPass() != pass) {
                return;
            }
            TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
            TextureAtlasSprite flowing = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFlowing().toString());
            BlockPos pos = te.func_174877_v();
            int mixedBrightness = te.func_145831_w().func_180495_p(pos).func_185889_a((IBlockAccess)te.func_145831_w(), te.func_174877_v());
            int skyLight = mixedBrightness >> 16 & 0xFFFF;
            int blockLight = mixedBrightness & 0xFFFF;
            double fullness = (double)fluidStack.amount / 4096.0;
            int rgbaColor = fluid.getColor();
            int rColor = rgbaColor >> 16 & 0xFF;
            int gColor = rgbaColor >> 8 & 0xFF;
            int bColor = rgbaColor & 0xFF;
            int aColor = rgbaColor >> 24 & 0xFF;
            worldRenderer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
            for (FluidModelVertex vert : this.model) {
                EnumFacing face = vert.face;
                TextureAtlasSprite sprite = face.func_96559_d() != 0 ? still : flowing;
                for (VertexFormatElement e : worldRenderer.func_178973_g().func_177343_g()) {
                    switch (e.func_177375_c()) {
                        case COLOR: {
                            worldRenderer.func_181669_b(rColor, gColor, bColor, aColor);
                            break;
                        }
                        case NORMAL: {
                            worldRenderer.func_181663_c((float)face.func_82601_c(), (float)face.func_96559_d(), (float)face.func_82599_e());
                            break;
                        }
                        case POSITION: {
                            double vertX = (double)pos.func_177958_n() + vert.x * 0.756 + 0.122;
                            double vertY = (double)pos.func_177956_o() + vert.yMultiplier * fullness * 0.756 + 0.122;
                            double vertZ = (double)pos.func_177952_p() + vert.z * 0.756 + 0.122;
                            worldRenderer.func_181662_b(vertX, vertY, vertZ);
                            break;
                        }
                        case UV: {
                            if (e.func_177369_e() == 1) {
                                worldRenderer.func_187314_a(skyLight, blockLight);
                                break;
                            }
                            worldRenderer.func_187315_a((double)sprite.func_94214_a(vert.u + vert.uMultiplier * fullness), (double)sprite.func_94207_b(16.0 - (vert.v + vert.vMultiplier * fullness)));
                            break;
                        }
                    }
                }
                worldRenderer.func_181675_d();
            }
        }
    }
}

