/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.mcmultipart;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import mcmultipart.microblock.IMicroMaterial;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.microblock.MicroblockClass;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.ISolidPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.BoxType;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.integration.mcmultipart.ChiseledMicroblock;
import mod.chiselsandbits.integration.mcmultipart.MultipartContainerWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChiseledBlockPart
extends Multipart
implements INormallyOccludingPart,
ISolidPart,
IMicroblock {
    protected TileEntityBlockChiseled inner;
    protected BlockChiseled bc;

    public void onAdded() {
        if (this.inner != null) {
            this.inner.func_145829_t();
        }
    }

    public void onRemoved() {
        if (this.inner != null) {
            this.inner.func_145843_s();
        }
    }

    public void saveChanges() {
        super.markDirty();
    }

    public void swapTile(TileEntityBlockChiseled newTileEntity) {
        newTileEntity.copyFrom(this.getTile());
        this.inner.func_145843_s();
        this.inner = newTileEntity;
        this.markRenderUpdate();
    }

    public boolean occlusionTest(IMultipart part) {
        return OcclusionHelper.defaultOcclusionTest((IMultipart)this, (IMultipart)part) && !(part instanceof ChiseledBlockPart);
    }

    public float getHardness(PartMOP hit) {
        return this.getTile().getBlockInfo((Block)this.getBlock()).hardness;
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        this.getBlock().addCollisionBoxesToList(this.getTile(), BlockPos.field_177992_a, mask, list, collidingEntity);
    }

    public RayTraceUtils.AdvancedRayTraceResultPart collisionRayTrace(Vec3d start, Vec3d end) {
        RayTraceResult mop = this.getBlock().collisionRayTrace(this.getTile(), this.getPos(), start, end, true);
        if (mop == null) {
            return null;
        }
        BlockPos myPos = this.getPos() == null ? BlockPos.field_177992_a : this.getPos();
        AxisAlignedBB bb = this.getBlock().getSelectedBoundingBox(this.getTile(), myPos);
        return new RayTraceUtils.AdvancedRayTraceResultPart(new PartMOP(mop, (IMultipart)this), bb == null ? null : bb.func_72317_d((double)(-myPos.func_177958_n()), (double)(-myPos.func_177956_o()), (double)(-myPos.func_177952_p())));
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.addAll(this.getTile().getBoxes(BoxType.OCCLUSION));
    }

    public TileEntityBlockChiseled getTile() {
        if (this.inner == null) {
            this.inner = new TileEntityBlockChiseled();
        }
        this.inner.func_145834_a(this.getWorld());
        this.inner.func_174878_a(this.getPos());
        if (!(this.inner.occlusionState instanceof MultipartContainerWrapper)) {
            this.inner.occlusionState = new MultipartContainerWrapper(this);
        }
        return this.inner;
    }

    public BlockChiseled getBlock() {
        if (this.bc == null) {
            this.bc = (BlockChiseled)ChiselsAndBits.getBlocks().getChiseledDefaultState().func_177230_c();
        }
        return this.bc;
    }

    public ResourceLocation getModelPath() {
        return this.getBlock().getModel();
    }

    public int getLightValue() {
        int lv = this.getTile().getLightValue();
        return lv;
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return this.getBlock().getPickBlock((RayTraceResult)hit, hit.func_178782_a(), this.getTile());
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getTile().getRenderState(world);
    }

    public List<ItemStack> getDrops() {
        return Collections.singletonList(this.getTile().getItemStack(null));
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        if (!(player != null && player.field_71075_bZ.field_75098_d || world.field_72995_K || !world.func_82736_K().func_82766_b("doTileDrops") || world.restoringBlockSnapshots)) {
            ItemStack stack = this.getTile().getItemStack(player);
            EntityItem item = new EntityItem(world, x, y, z, stack);
            item.func_174869_p();
            world.func_72838_d((Entity)item);
        }
        this.getContainer().removePart((IMultipart)this);
    }

    public BlockStateContainer createBlockState() {
        return this.getBlock().func_176194_O();
    }

    public boolean rotatePart(EnumFacing axis) {
        this.getTile().rotateBlock(axis);
        return true;
    }

    public EnumFacing[] getValidRotations() {
        return EnumFacing.field_82609_l;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        this.getTile().writeChisleData(tag);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_82582_d()) {
            return;
        }
        this.getTile().readChisleData(tag);
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.getTile().writeChisleData(tag);
        buf.func_150786_a(tag);
    }

    public void readUpdatePacket(PacketBuffer buf) {
        try {
            NBTTagCompound tag = buf.func_150793_b();
            this.getTile().readChisleData(tag);
        }
        catch (IOException e) {
            Log.logError("Invalid Chisled Block Packet.", e);
        }
    }

    public void notifyPartUpdate() {
        super.notifyPartUpdate();
    }

    public boolean isSideSolid(EnumFacing side) {
        return this.getTile().isSideSolid(side);
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.noneOf(PartSlot.class);
    }

    public AxisAlignedBB getBounds() {
        return this.getBlock().getSelectedBoundingBox(this.getTile(), this.getPos());
    }

    public MicroblockClass getMicroClass() {
        return ChiseledMicroblock.instance;
    }

    public IMicroMaterial getMicroMaterial() {
        return (IMicroMaterial)this;
    }

    public int getSize() {
        return 0;
    }

    public PartSlot getSlot() {
        return null;
    }

    public void setSize(int arg0) {
    }

    public void setSlot(PartSlot arg0) {
    }

    public Boolean isAABBInsideMaterial(AxisAlignedBB bx, Material materialIn) {
        return BlockChiseled.sharedIsAABBInsideMaterial(this.getTile(), bx, materialIn);
    }

    public Boolean isEntityInsideMaterial(Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return BlockChiseled.sharedIsEntityInsideMaterial(this.getTile(), this.getPos(), entity, yToTest, materialIn, testingHead);
    }
}

