/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.ChangePacket;
import assets.recipehandler.CraftingHandler;
import assets.recipehandler.GuiEventHandler;
import assets.recipehandler.RecipeMod;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class ClientEventHandler
implements RecipeMod.IRegister {
    private KeyBinding key;
    private ItemStack oldItem = null;
    private boolean pressed = false;

    @Override
    public void register() {
        if (RecipeMod.switchKey) {
            this.key = new KeyBinding("RecipeSwitch", (IKeyConflictContext)KeyConflictContext.GUI, 78, "key.categories.gui");
            ClientRegistry.registerKeyBinding((KeyBinding)this.key);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (RecipeMod.cycleButton) {
            MinecraftForge.EVENT_BUS.register((Object)GuiEventHandler.INSTANCE);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public void scheduleTask(Runnable runner) {
        FMLClientHandler.instance().getClient().func_152344_a(runner);
    }

    public static World getWorld() {
        return FMLClientHandler.instance().getWorldClient();
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Text event) {
        int result;
        if (this.getPlayer() != null && RecipeMod.cornerText && (result = CraftingHandler.getNumberOfCraft(this.getPlayer().field_71070_bA, ClientEventHandler.getWorld())) > 1) {
            event.getRight().add(I18n.func_74837_a((String)"handler.found.text", (Object[])new Object[]{result}));
        }
    }

    @SubscribeEvent
    public void keyDown(TickEvent.ClientTickEvent event) {
        if (this.getPlayer() != null && FMLClientHandler.instance().getClient().field_71462_r != null) {
            if (event.phase == TickEvent.Phase.START && this.key != null) {
                if (Keyboard.isKeyDown((int)this.key.func_151463_i())) {
                    if (!this.pressed) {
                        this.pressed = true;
                        this.pressed();
                    }
                } else if (this.pressed) {
                    this.pressed = false;
                }
            }
            if (event.phase == TickEvent.Phase.END && Mouse.isButtonDown((int)0) && GuiScreen.func_146272_n()) {
                ItemStack res;
                InventoryCrafting craft;
                Slot result = null;
                if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer) {
                    Slot slot = ((GuiContainer)FMLClientHandler.instance().getClient().field_71462_r).getSlotUnderMouse();
                    if (slot == null) {
                        return;
                    }
                    if (slot instanceof SlotCrafting) {
                        result = slot;
                    }
                }
                if (result == null) {
                    result = CraftingHandler.getResultSlot(this.getPlayer().field_71070_bA, 0);
                }
                if (result != null && (craft = CraftingHandler.getCraftingMatrix(this.getPlayer().field_71070_bA)) != null && (res = CraftingHandler.findMatchingRecipe(craft, ClientEventHandler.getWorld())) != null && !ItemStack.func_77989_b((ItemStack)res, (ItemStack)result.func_75211_c())) {
                    RecipeMod.networkWrapper.sendToServer(new ChangePacket(result.field_75222_d, res, CraftingHandler.getRecipeIndex()).toProxy(Side.SERVER));
                    this.oldItem = res;
                }
            }
        }
    }

    public void pressed() {
        InventoryCrafting craft = CraftingHandler.getCraftingMatrix(this.getPlayer().field_71070_bA);
        if (craft != null) {
            ItemStack res = CraftingHandler.findNextMatchingRecipe(craft, ClientEventHandler.getWorld());
            if (res == null) {
                this.oldItem = null;
            } else if (!ItemStack.func_77989_b((ItemStack)res, (ItemStack)this.oldItem)) {
                int index = 0;
                Slot slot = CraftingHandler.getResultSlot(this.getPlayer().field_71070_bA, index);
                if (slot != null) {
                    index = slot.field_75222_d;
                }
                RecipeMod.networkWrapper.sendToServer(new ChangePacket(index, res, CraftingHandler.getRecipeIndex()).toProxy(Side.SERVER));
                this.oldItem = res;
            }
        }
    }
}

