/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCore;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockFluidAerotheum
extends BlockFluidCore {
    public static final int LEVELS = 6;
    public static final Material materialFluidAerotheum = new MaterialLiquid(MapColor.field_151660_b);
    private static boolean effect = true;
    private static boolean enableSourceDissipate = true;
    private static boolean enableSourceFloat = true;
    private static int maxHeight = 120;

    public BlockFluidAerotheum(Fluid fluid) {
        super(fluid, materialFluidAerotheum, "thermalfoundation", "aerotheum");
        this.setQuantaPerBlock(6);
        this.setTickRate(8);
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.setParticleColor(0.65f, 0.65f, 0.48f);
    }

    public static void config() {
        String category = "Fluid.Aerotheum";
        String comment = "If TRUE, Fluid Aerotheum will slow and redirect entities on contact.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
        comment = "If TRUE, Fluid Aerotheum Source blocks will dissipate back into air above a given y-value.";
        enableSourceDissipate = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Dissipate", category, enableSourceDissipate, comment);
        comment = "If TRUE, Fluid Aerotheum Source blocks will gradually float upwards.";
        enableSourceFloat = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Float", category, enableSourceFloat, comment);
        comment = "This adjusts the y-value where Fluid Aerotheum will *always* dissipate, if that is enabled.";
        maxHeight = ThermalFoundation.CONFIG.getConfiguration().getInt("MaxHeight", category, maxHeight, maxHeight / 2, maxHeight * 2, comment);
    }

    private boolean shouldSourceBlockDissipate(World world, BlockPos pos) {
        int y = pos.func_177956_o();
        return enableSourceDissipate && (y + this.densityDir > maxHeight || y + this.densityDir > world.func_72800_K() || (float)(y + this.densityDir) > (float)maxHeight * 0.8f && !this.canDisplace((IBlockAccess)world, pos.func_177982_a(0, this.densityDir, 0)));
    }

    private boolean shouldSourceBlockFloat(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177982_a(0, this.densityDir, 0));
        return enableSourceFloat && state.func_177230_c() == this && this.func_176201_c(state) != 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!effect) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            if (entity.field_70159_w > 0.1) {
                entity.field_70159_w = 0.1;
            }
            if (entity.field_70179_y > 0.1) {
                entity.field_70179_y = 0.1;
            }
            if (entity.field_70181_x < -0.2) {
                entity.field_70181_x *= 0.5;
                entity.field_70143_R = entity.field_70143_R > 20.0f ? 20.0f : (float)((double)entity.field_70143_R * 0.5);
            }
        } else if (entity instanceof IProjectile) {
            entity.field_70159_w *= world.field_73012_v.nextGaussian() * 1.5;
            entity.field_70179_y *= world.field_73012_v.nextGaussian() * 1.5;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76441_p, 60, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76427_o, 600, 0));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidAerotheum.getLuminosity();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176201_c(state) == 0) {
            if (this.shouldSourceBlockDissipate(world, pos)) {
                world.func_175698_g(pos);
                return;
            }
            if (rand.nextInt(3) == 0 && this.shouldSourceBlockFloat(world, pos)) {
                world.func_180501_a(pos.func_177982_a(0, this.densityDir, 0), this.func_176223_P(), 3);
                world.func_175698_g(pos);
                return;
            }
        } else if (pos.func_177956_o() > maxHeight) {
            world.func_175698_g(pos);
            return;
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (pos.func_177956_o() > maxHeight) {
            return;
        }
        super.flowIntoBlock(world, pos, meta);
    }

    public boolean preInit() {
        this.setRegistryName("fluid_aerotheum");
        GameRegistry.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        BlockFluidAerotheum.config();
        return true;
    }
}

