/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.props.DecoModelMetadata;
import com.mia.props.Props;
import com.mia.props.common.TileProps;
import com.mia.props.events.SoundRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockProps
extends BlockContainer
implements ITileEntityProvider {
    private static final Cache<Object, TimedBool> eggedEntities = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(2500L, TimeUnit.MILLISECONDS).build();

    public BlockProps() {
        super(Material.field_151580_n);
        this.func_149711_c(0.25f);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = null;
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            Item item = Props.itemProps;
            ItemStack itemStack = stack = item == null ? null : new ItemStack(item, 1, ((TileProps)tile).type);
            if (player.func_70093_af() && ((TileProps)tile).onItemStackDropSaveNBT()) {
                NBTTagCompound tag = tile.func_189515_b(new NBTTagCompound());
                tag.func_82580_o("slaves");
                stack.func_77983_a("savedProp", (NBTBase)tag);
            }
        }
        return stack;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            DecoModelMetadata data = Props.modelData.get(((TileProps)tile).type);
            if (data.walkthrough) {
                return;
            }
            CSModel model = data.csmodel;
            for (CSModel.ModelNode node : model.getNodes()) {
                if (node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLE) || node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) continue;
                Vector3[] extend = data.wrapper.nodeCache.get(node).getExtend(((TileProps)tile).rotation);
                AxisAlignedBB aabb = new AxisAlignedBB((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
                AxisAlignedBB aabbTmp = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (!entityBox.func_72326_a(aabbTmp)) continue;
                collidingBoxes.add(aabbTmp);
            }
        } else {
            super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(source, pos);
        if (tile instanceof TileProps) {
            TileProps tileProps = (TileProps)tile;
            return Props.modelData.get(tileProps.type).getBoundingBox(tileProps.rotation);
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)worldIn, pos);
        if (tile instanceof TileProps) {
            DecoModelMetadata data = Props.modelData.get(((TileProps)tile).type);
            if (data.walkthrough) {
                return null;
            }
            CSModel model = data.csmodel;
            AxisAlignedBB ret = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            for (CSModel.ModelNode node : model.getNodes()) {
                if (node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLE) || node.hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) continue;
                Vector3[] extend = data.wrapper.nodeCache.get(node).getExtend(((TileProps)tile).rotation);
                AxisAlignedBB aabb = new AxisAlignedBB((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
                AxisAlignedBB aabbTmp = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                ret.func_111270_a(aabbTmp);
            }
            return ret;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            DecoModelMetadata data = Props.modelData.get(((TileProps)tile).type);
            RayTraceResult closest = null;
            CSModel model = data.csmodel;
            for (CSModel.ModelNode node : model.getNodes()) {
                Vector3[] extend = data.wrapper.nodeCache.get(node).getExtend(((TileProps)tile).rotation);
                AxisAlignedBB aabb = new AxisAlignedBB((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
                RayTraceResult mop = aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72327_a(origin, direction);
                if (mop == null) continue;
                if (closest != null && mop.field_72307_f.func_72438_d(origin) < closest.field_72307_f.func_72438_d(origin)) {
                    closest = mop;
                    continue;
                }
                closest = mop;
            }
            if (closest != null) {
                closest = new RayTraceResult(closest.field_72307_f, closest.field_178784_b, pos);
            }
            return closest;
        }
        return super.func_180636_a(state, world, pos, origin, direction);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return Props.modelData.get((Object)Integer.valueOf((int)meta)).tileType.getTileClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.printf("!!! CRITICAL ERROR : PRB WHILE LOADING TE FOR META %s !!!\n", meta);
            throw new RuntimeException(e);
        }
        return new TileProps();
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).getLightValue(world, pos);
        }
        return 0;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        NBTTagCompound savedNBT = null;
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            TileProps tileProps = (TileProps)tile;
            if (tileProps.onItemStackDropSaveNBT()) {
                savedNBT = new NBTTagCompound();
                tile.func_189515_b(savedNBT);
                savedNBT.func_82580_o("slaves");
            }
            tileProps.onBlockHarvested(world, pos, state, player);
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack droppedItem = new ItemStack(Props.itemProps, 1, tileProps.type);
                if (savedNBT != null) {
                    droppedItem.func_77983_a("savedProp", (NBTBase)savedNBT);
                }
                BlockProps.func_180635_a((World)world, (BlockPos)pos, (ItemStack)droppedItem);
            }
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).onBlockClicked(world, pos, player);
        }
    }

    private void playBlockSound(World world, TileProps prop, Entity player) {
        String sfx;
        if (world.field_72995_K) {
            return;
        }
        if (prop != null && (sfx = Props.modelData.get((Object)Integer.valueOf((int)prop.type)).sound) != null) {
            world.func_184133_a((EntityPlayer)null, prop.func_174877_v(), SoundRegistry.get(sfx), SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)worldIn, pos);
        if (tile instanceof TileProps) {
            this.playBlockSound(worldIn, (TileProps)tile, (Entity)playerIn);
            return ((TileProps)tile).onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)worldIn, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).renderParticles(worldIn, pos, stateIn, rand);
        }
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).isBed();
        }
        return false;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps && ((TileProps)tile).isBed()) {
            return EnumFacing.values()[((TileProps)tile).rotation / 4];
        }
        return super.getBedDirection(state, world, pos);
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return super.isBedFoot(world, pos);
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).setBedOccupied(world, pos, player, occupied);
        }
    }

    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = Props.getTileEntityPreferNotCreating(world, pos);
        if (tile instanceof TileProps) {
            return ((TileProps)tile).getBedSpawnPosition(world, pos, player);
        }
        return pos;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity master = Props.getTileEntityPreferNotCreating((IBlockAccess)world, pos);
        if (master instanceof TileProps) {
            ((TileProps)master).removeSlaves();
        }
        this.func_176208_a(world, pos, state, player);
        world.func_175698_g(pos);
        return true;
    }

    private static void eggCacheAndSpawnEntity(Entity newSpawn, World world, double x, double y, double z) {
        newSpawn.func_70012_b(x + (double)((world.field_73012_v.nextFloat() - 0.5f) / 4.0f), y + (double)((world.field_73012_v.nextFloat() - 0.5f) / 4.0f), z + (double)((world.field_73012_v.nextFloat() - 0.5f) / 4.0f), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        newSpawn.func_70110_aj();
        world.func_72838_d(newSpawn);
        eggedEntities.put((Object)newSpawn, (Object)new TimedBool(false, System.currentTimeMillis()));
    }

    static void onEntityWebbed(Entity webbedEntity, World world) {
        webbedEntity.func_70110_aj();
        if (world.field_72995_K || webbedEntity.field_70128_L) {
            return;
        }
        TimedBool egged = (TimedBool)eggedEntities.getIfPresent((Object)webbedEntity);
        if (egged == null || !egged.value && egged.time + 500L <= System.currentTimeMillis()) {
            if (egged == null) {
                egged = new TimedBool(true, System.currentTimeMillis());
            }
            egged.value = true;
            eggedEntities.put((Object)webbedEntity, (Object)egged);
            if (webbedEntity instanceof EntitySpider) {
                if ((double)world.field_73012_v.nextFloat() <= 0.3) {
                    Constructor<?>[] ctors = webbedEntity.getClass().getDeclaredConstructors();
                    Constructor<?> ctor = null;
                    for (int i = 0; i < ctors.length; ++i) {
                        if (ctors[i].getParameterTypes().length != 1 || !ctors[i].getParameterTypes()[0].isAssignableFrom(World.class)) continue;
                        ctor = ctors[i];
                        break;
                    }
                    if (ctor != null) {
                        try {
                            BlockProps.eggCacheAndSpawnEntity((Entity)ctor.newInstance(world), world, webbedEntity.field_70165_t, webbedEntity.field_70163_u, webbedEntity.field_70161_v);
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                }
            } else if (webbedEntity instanceof EntityPlayer && (double)world.field_73012_v.nextFloat() <= 0.5) {
                BlockProps.eggCacheAndSpawnEntity((Entity)new EntitySpider(world), world, webbedEntity.field_70165_t, webbedEntity.field_70163_u, webbedEntity.field_70161_v);
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)worldIn, pos);
        if (tile instanceof TileProps && ((TileProps)tile).getModelData().spiderweb) {
            BlockProps.onEntityWebbed(entityIn, worldIn);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        TileEntity tile = Props.getTileEntityPreferNotCreating((IBlockAccess)worldIn, pos);
        if (tile instanceof TileProps) {
            ((TileProps)tile).neighborChanged(state, worldIn, pos, blockIn);
        }
    }

    private static class TimedBool {
        public boolean value;
        public long time;

        public TimedBool(boolean v, long t) {
            this.value = v;
            this.time = t;
        }
    }
}

