/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import net.minecraftforge.fml.common.discovery.ASMDataTable;
import openblocks.api.ApiHolder;
import openblocks.api.IApiInterface;
import openblocks.api.OpenBlocksApi;
import openblocks.enchantments.flimflams.FlimFlamRegistry;
import openmods.Log;
import openmods.access.ApiFactory;
import openmods.access.ApiProviderBase;
import openmods.access.ApiProviderRegistry;

public class ApiSetup {
    private final ApiProviderRegistry<IApiInterface> registry = new ApiProviderRegistry(IApiInterface.class);

    ApiSetup() {
    }

    public void setupApis() {
        this.registry.registerInstance((Object)FlimFlamRegistry.instance);
        this.registry.freeze();
    }

    public void installHolderAccess(ASMDataTable table) {
        ApiFactory.instance.createApi(ApiHolder.class, IApiInterface.class, table, this.registry);
    }

    void injectProvider() {
        try {
            OpenBlocksApi.init(new ApiProviderAdapter(this.registry));
        }
        catch (Throwable t) {
            String apiSource = ApiSetup.getApiSource();
            throw new IllegalStateException(String.format("Failed to register OpenBlocks API provider (ApiAccess source: %s)", apiSource), t);
        }
    }

    private static String getApiSource() {
        try {
            return OpenBlocksApi.ApiProvider.class.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable t) {
            Log.severe((Throwable)t, (String)"Failed to get OpenBlocks API source", (Object[])new Object[0]);
            return "<unknown, see logs>";
        }
    }

    private static class ApiProviderAdapter
    extends ApiProviderBase<IApiInterface>
    implements OpenBlocksApi.ApiProvider {
        public ApiProviderAdapter(ApiProviderRegistry<IApiInterface> apiRegistry) {
            super(apiRegistry);
        }
    }
}

