/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.IOpenBlocksProxy;
import openblocks.OpenBlocks;
import openblocks.client.ClientTickHandler;
import openblocks.client.GliderPlayerRenderHandler;
import openblocks.client.SleepingBagRenderHandler;
import openblocks.client.SoundEventsManager;
import openblocks.client.bindings.KeyInputHandler;
import openblocks.client.fx.FXLiquidSpray;
import openblocks.client.model.ModelBearTrap;
import openblocks.client.model.ModelCraneBackpack;
import openblocks.client.model.ModelPiggy;
import openblocks.client.model.ModelSprinkler;
import openblocks.client.renderer.SkyBlockRenderer;
import openblocks.client.renderer.TextureUploader;
import openblocks.client.renderer.block.PathModel;
import openblocks.client.renderer.block.canvas.CanvasTextureManager;
import openblocks.client.renderer.block.canvas.ModelCanvas;
import openblocks.client.renderer.entity.EntityCartographerRenderer;
import openblocks.client.renderer.entity.EntityHangGliderRenderer;
import openblocks.client.renderer.entity.EntityLuggageRenderer;
import openblocks.client.renderer.entity.EntityMagnetRenderer;
import openblocks.client.renderer.entity.EntityMiniMeRenderer;
import openblocks.client.renderer.entity.EntitySelectionHandler;
import openblocks.client.renderer.item.devnull.DevNullModel;
import openblocks.client.renderer.item.stencil.ModelStencil;
import openblocks.client.renderer.item.stencil.StencilItemOverride;
import openblocks.client.renderer.item.stencil.StencilTextureManager;
import openblocks.client.renderer.tileentity.TileEntityAutoEnchantmentTableRenderer;
import openblocks.client.renderer.tileentity.TileEntityCannonRenderer;
import openblocks.client.renderer.tileentity.TileEntityFanRenderer;
import openblocks.client.renderer.tileentity.TileEntityGoldenEggRenderer;
import openblocks.client.renderer.tileentity.TileEntityGraveRenderer;
import openblocks.client.renderer.tileentity.TileEntityImaginaryRenderer;
import openblocks.client.renderer.tileentity.TileEntityPaintMixerRenderer;
import openblocks.client.renderer.tileentity.TileEntityProjectorRenderer;
import openblocks.client.renderer.tileentity.TileEntitySkyRenderer;
import openblocks.client.renderer.tileentity.TileEntityTankRenderer;
import openblocks.client.renderer.tileentity.TileEntityTrophyRenderer;
import openblocks.client.renderer.tileentity.TileEntityVillageHighlighterRenderer;
import openblocks.client.renderer.tileentity.guide.TileEntityBuilderGuideRenderer;
import openblocks.client.renderer.tileentity.guide.TileEntityGuideRenderer;
import openblocks.common.StencilPattern;
import openblocks.common.TrophyHandler;
import openblocks.common.block.BlockCanvas;
import openblocks.common.block.BlockElevator;
import openblocks.common.block.BlockFlag;
import openblocks.common.block.BlockPaintCan;
import openblocks.common.block.BlockPaintMixer;
import openblocks.common.entity.EntityCartographer;
import openblocks.common.entity.EntityGoldenEye;
import openblocks.common.entity.EntityHangGlider;
import openblocks.common.entity.EntityLuggage;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.entity.EntityMiniMe;
import openblocks.common.item.ItemDevNull;
import openblocks.common.item.ItemElevator;
import openblocks.common.item.ItemFlagBlock;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemImaginationGlasses;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemPaintCan;
import openblocks.common.tileentity.TileEntityAutoEnchantmentTable;
import openblocks.common.tileentity.TileEntityBearTrap;
import openblocks.common.tileentity.TileEntityBuilderGuide;
import openblocks.common.tileentity.TileEntityCannon;
import openblocks.common.tileentity.TileEntityDonationStation;
import openblocks.common.tileentity.TileEntityFan;
import openblocks.common.tileentity.TileEntityGoldenEgg;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.common.tileentity.TileEntityImaginary;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openblocks.common.tileentity.TileEntityProjector;
import openblocks.common.tileentity.TileEntitySky;
import openblocks.common.tileentity.TileEntitySprinkler;
import openblocks.common.tileentity.TileEntityTank;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openblocks.enchantments.flimflams.LoreFlimFlam;
import openmods.block.OpenBlock;
import openmods.entity.EntityBlock;
import openmods.entity.renderer.EntityBlockRenderer;
import openmods.model.MappedModelLoader;
import openmods.model.ModelUtils;
import openmods.renderer.ITileEntityModel;
import openmods.renderer.SimpleModelTileEntityRenderer;
import openmods.utils.render.MarkerClassGenerator;

public class ClientProxy
implements IOpenBlocksProxy {
    public void preInit() {
        new KeyInputHandler().setup();
        if (Config.flimFlamEnchantmentEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new LoreFlimFlam.DisplayHandler());
        }
        if (OpenBlocks.Blocks.trophy != null) {
            Item trophyItem = Item.func_150898_a((Block)OpenBlocks.Blocks.trophy);
            for (TrophyHandler.Trophy trophy : TrophyHandler.Trophy.VALUES) {
                ClientProxy.registerTrophyItemRenderer(trophyItem, trophy);
            }
        }
        ClientProxy.registerTesrStateMappers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)MappedModelLoader.builder().put("magic-devnull", (IModel)DevNullModel.INSTANCE).put("magic-path", (IModel)PathModel.INSTANCE).put("magic-stencil", (IModel)ModelStencil.INSTANCE).put("magic-canvas", ModelCanvas.INSTANCE).build("openblocks"));
        if (OpenBlocks.Items.hangGlider != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityHangGlider.class, (IRenderFactory)new IRenderFactory<EntityHangGlider>(){

                public Render<EntityHangGlider> createRenderFor(RenderManager manager) {
                    return new EntityHangGliderRenderer(manager);
                }
            });
        }
        if (OpenBlocks.Items.luggage != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityLuggage.class, (IRenderFactory)new IRenderFactory<EntityLuggage>(){

                public Render<EntityLuggage> createRenderFor(RenderManager manager) {
                    return new EntityLuggageRenderer(manager);
                }
            });
        }
        if (OpenBlocks.Items.craneBackpack != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityMagnet.class, (IRenderFactory)new IRenderFactory<EntityMagnet>(){

                public Render<? super EntityMagnet> createRenderFor(RenderManager manager) {
                    return new EntityMagnetRenderer(manager);
                }
            });
            RenderingRegistry.registerEntityRenderingHandler(EntityBlock.class, (IRenderFactory)new IRenderFactory<EntityBlock>(){

                public Render<? super EntityBlock> createRenderFor(RenderManager manager) {
                    return new EntityBlockRenderer(manager);
                }
            });
        }
        if (OpenBlocks.Blocks.goldenEgg != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityMiniMe.class, (IRenderFactory)new IRenderFactory<EntityMiniMe>(){

                public Render<? super EntityMiniMe> createRenderFor(RenderManager manager) {
                    return new EntityMiniMeRenderer(manager);
                }
            });
        }
        if (OpenBlocks.Items.cartographer != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCartographer.class, (IRenderFactory)new IRenderFactory<EntityCartographer>(){

                public Render<? super EntityCartographer> createRenderFor(RenderManager manager) {
                    return new EntityCartographerRenderer(manager).registerListener();
                }
            });
        }
        if (OpenBlocks.Items.goldenEye != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityGoldenEye.class, (IRenderFactory)new IRenderFactory<EntityGoldenEye>(){

                public Render<? super EntityGoldenEye> createRenderFor(RenderManager manager) {
                    return new RenderSnowball(manager, (Item)OpenBlocks.Items.goldenEye, Minecraft.func_71410_x().func_175599_af());
                }
            });
        }
        if (OpenBlocks.Items.stencil != null) {
            StencilTextureManager.INSTANCE.register(StencilItemOverride.BACKGROUND_TEXTURE, StencilPattern.values().length);
            MinecraftForge.EVENT_BUS.register((Object)StencilTextureManager.INSTANCE);
            ModelUtils.registerMetaInsensitiveModel((Item)OpenBlocks.Items.stencil);
        }
        if (OpenBlocks.Blocks.canvas != null) {
            MinecraftForge.EVENT_BUS.register((Object)CanvasTextureManager.INSTANCE);
        }
        if (OpenBlocks.Items.stencil != null || OpenBlocks.Blocks.canvas != null) {
            MinecraftForge.EVENT_BUS.register((Object)TextureUploader.INSTANCE);
        }
        if (OpenBlocks.Blocks.elevator != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.elevator));
        }
        if (OpenBlocks.Blocks.elevatorRotating != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)Item.func_150898_a((Block)OpenBlocks.Blocks.elevatorRotating));
        }
        if (OpenBlocks.Blocks.sky != null) {
            ModelUtils.registerMetaInsensitiveModel((Block)OpenBlocks.Blocks.sky);
            SkyBlockRenderer.INSTANCE.setup();
        }
        if (OpenBlocks.Items.heightMap != null) {
            ModelUtils.registerMetaInsensitiveModel((Item)OpenBlocks.Items.heightMap);
        }
        if (OpenBlocks.Blocks.flag != null) {
            ModelUtils.registerMetaInsensitiveModel((Block)OpenBlocks.Blocks.flag);
        }
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EntityMiniMe.OwnerChangeHandler());
    }

    public void postInit() {
        SoundEventsManager.instance.init();
    }

    public void registerRenderInformation() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGuide.class, new TileEntityGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBuilderGuide.class, (TileEntitySpecialRenderer)new TileEntityBuilderGuideRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGrave.class, (TileEntitySpecialRenderer)new TileEntityGraveRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTank.class, (TileEntitySpecialRenderer)new TileEntityTankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophy.class, (TileEntitySpecialRenderer)new TileEntityTrophyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBearTrap.class, (TileEntitySpecialRenderer)SimpleModelTileEntityRenderer.create((ITileEntityModel)new ModelBearTrap(), (ResourceLocation)OpenBlocks.location("textures/models/bear_trap.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySprinkler.class, (TileEntitySpecialRenderer)SimpleModelTileEntityRenderer.create((ITileEntityModel)new ModelSprinkler(), (ResourceLocation)OpenBlocks.location("textures/models/sprinkler.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCannon.class, (TileEntitySpecialRenderer)new TileEntityCannonRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityImaginary.class, (TileEntitySpecialRenderer)new TileEntityImaginaryRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFan.class, (TileEntitySpecialRenderer)new TileEntityFanRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVillageHighlighter.class, (TileEntitySpecialRenderer)new TileEntityVillageHighlighterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAutoEnchantmentTable.class, (TileEntitySpecialRenderer)new TileEntityAutoEnchantmentTableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDonationStation.class, (TileEntitySpecialRenderer)SimpleModelTileEntityRenderer.create((ITileEntityModel)new ModelPiggy(), (ResourceLocation)OpenBlocks.location("textures/models/piggy.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPaintMixer.class, (TileEntitySpecialRenderer)new TileEntityPaintMixerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySky.class, (TileEntitySpecialRenderer)new TileEntitySkyRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGoldenEgg.class, (TileEntitySpecialRenderer)new TileEntityGoldenEggRenderer());
        if (OpenBlocks.Blocks.projector != null) {
            ModelResourceLocation spinnerModel = new ModelResourceLocation(OpenBlocks.Blocks.projector.getRegistryName(), "spinner");
            TileEntityProjectorRenderer renderer = new TileEntityProjectorRenderer(spinnerModel);
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityProjector.class, (TileEntitySpecialRenderer)renderer);
            MinecraftForge.EVENT_BUS.register((Object)renderer);
        }
        ClientProxy.registerTesrItemRenderers();
        if (OpenBlocks.Blocks.tank != null) {
            MinecraftForge.EVENT_BUS.register((Object)new FluidTextureRegisterListener());
        }
        if (OpenBlocks.Items.hangGlider != null) {
            MinecraftForge.EVENT_BUS.register((Object)new GliderPlayerRenderHandler());
        }
        if (OpenBlocks.Items.sonicGlasses != null) {
            MinecraftForge.EVENT_BUS.register((Object)SoundEventsManager.instance);
        }
        if (OpenBlocks.Items.craneBackpack != null) {
            ModelCraneBackpack.instance.init();
        }
        if (OpenBlocks.Items.sleepingBag != null) {
            MinecraftForge.EVENT_BUS.register((Object)new SleepingBagRenderHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)new EntitySelectionHandler());
        if (OpenBlocks.Items.cartographer != null) {
            EntitySelectionHandler.registerRenderer(EntityCartographer.class, new EntityCartographerRenderer.Selection());
        }
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        if (OpenBlocks.Items.paintBrush != null) {
            itemColors.func_186730_a((IItemColor)new ItemPaintBrush.ColorHandler(), new Item[]{OpenBlocks.Items.paintBrush});
        }
        if (OpenBlocks.Items.crayonGlasses != null) {
            itemColors.func_186730_a((IItemColor)new ItemImaginationGlasses.CrayonColorHandler(), new Item[]{OpenBlocks.Items.crayonGlasses});
        }
        if (OpenBlocks.Blocks.paintCan != null) {
            itemColors.func_186731_a((IItemColor)new ItemPaintCan.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.paintCan});
            blockColors.func_186722_a((IBlockColor)new BlockPaintCan.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.paintCan});
        }
        if (OpenBlocks.Blocks.imaginary != null) {
            itemColors.func_186731_a((IItemColor)new ItemImaginary.CrayonColorHandler(), new Block[]{OpenBlocks.Blocks.imaginary});
            MinecraftForge.EVENT_BUS.register((Object)new TileEntityImaginaryRenderer.CacheFlushListener());
        }
        if (OpenBlocks.Items.devNull != null) {
            itemColors.func_186730_a((IItemColor)new ItemDevNull.NestedItemColorHandler(itemColors), new Item[]{OpenBlocks.Items.devNull});
        }
        if (OpenBlocks.Blocks.elevator != null) {
            blockColors.func_186722_a((IBlockColor)new BlockElevator.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.elevator});
            itemColors.func_186731_a((IItemColor)new ItemElevator.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.elevator});
        }
        if (OpenBlocks.Blocks.elevatorRotating != null) {
            blockColors.func_186722_a((IBlockColor)new BlockElevator.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.elevatorRotating});
            itemColors.func_186731_a((IItemColor)new ItemElevator.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.elevatorRotating});
        }
        if (OpenBlocks.Blocks.canvas != null) {
            blockColors.func_186722_a((IBlockColor)new BlockCanvas.InnerBlockColorHandler(blockColors), new Block[]{OpenBlocks.Blocks.canvas});
        }
        if (OpenBlocks.Blocks.flag != null) {
            itemColors.func_186731_a((IItemColor)new ItemFlagBlock.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.flag});
            blockColors.func_186722_a((IBlockColor)new BlockFlag.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.flag});
        }
        if (OpenBlocks.Blocks.paintMixer != null) {
            blockColors.func_186722_a((IBlockColor)new BlockPaintMixer.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.paintMixer});
        }
    }

    private static void registerTrophyItemRenderer(Item item, TrophyHandler.Trophy trophy) {
        Class markerCls = MarkerClassGenerator.instance.createMarkerCls(TileEntityTrophy.class);
        int meta = trophy.ordinal();
        ForgeHooksClient.registerTESRItemStack((Item)item, (int)meta, (Class)markerCls);
        ClientRegistry.bindTileEntitySpecialRenderer((Class)markerCls, (TileEntitySpecialRenderer)new TileEntityTrophyRenderer(trophy));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(OpenBlocks.location("trophy"), "inventory"));
    }

    private static void visitTesrBlocks(BlockConsumer consumer) {
        consumer.nom((OpenBlock)OpenBlocks.Blocks.donationStation);
        consumer.nom((OpenBlock)OpenBlocks.Blocks.bearTrap);
        consumer.nom(OpenBlocks.Blocks.cannon);
        consumer.nom(OpenBlocks.Blocks.fan);
        consumer.nom((OpenBlock)OpenBlocks.Blocks.sprinkler);
    }

    private static void registerTesrItemRenderers() {
        ClientProxy.visitTesrBlocks(new BlockConsumer(){

            @Override
            public void nomNom(OpenBlock block) {
                Item item = Item.func_150898_a((Block)block);
                ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, (Class)block.getTileClass());
            }
        });
    }

    private static void registerTesrStateMappers() {
        ClientProxy.visitTesrBlocks(new BlockConsumer(){

            @Override
            public void nomNom(OpenBlock block) {
                ImmutableMap.Builder statesBuilder = ImmutableMap.builder();
                ModelResourceLocation location = new ModelResourceLocation(block.getRegistryName(), "dummy");
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    statesBuilder.put((Object)state, (Object)location);
                }
                ImmutableMap states = statesBuilder.build();
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new IStateMapper((Map)states){
                    final /* synthetic */ Map val$states;
                    {
                        this.val$states = map;
                    }

                    public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
                        return this.val$states;
                    }
                });
            }
        });
    }

    @Override
    public int getParticleSettings() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    private static void spawnParticle(Particle spray) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(spray);
    }

    @Override
    public void spawnLiquidSpray(World worldObj, FluidStack fluid, double x, double y, double z, float scale, float gravity, Vec3d velocity) {
        ClientProxy.spawnParticle(new FXLiquidSpray(worldObj, fluid, x, y, z, scale, gravity, velocity));
    }

    private static abstract class BlockConsumer {
        private BlockConsumer() {
        }

        public final void nom(OpenBlock block) {
            if (block != null) {
                this.nomNom(block);
            }
        }

        protected abstract void nomNom(OpenBlock var1);
    }

    private static class FluidTextureRegisterListener {
        private FluidTextureRegisterListener() {
        }

        @SubscribeEvent
        public void onTextureStitch(TextureStitchEvent.Pre evt) {
            for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
                ResourceLocation fluidTexture = f.getStill();
                if (fluidTexture == null) continue;
                evt.getMap().func_174942_a(fluidTexture);
            }
        }
    }
}

