/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import openblocks.Config;
import openblocks.common.container.ContainerItemDropper;
import openblocks.common.tileentity.TileEntityItemDropper;
import openblocks.rpc.IItemDropper;
import openmods.container.ContainerBase;
import openmods.gui.BaseGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentCheckbox;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSlider;
import openmods.gui.listener.IValueChangedListener;
import openmods.utils.TranslationUtils;

public class GuiItemDropper
extends BaseGuiContainer<ContainerItemDropper> {
    public GuiItemDropper(ContainerItemDropper container) {
        super((ContainerBase)container, 300, 167, "openblocks.gui.itemdropper");
        TileEntityItemDropper owner = (TileEntityItemDropper)container.getOwner();
        final IItemDropper rpc = owner.createRpcProxy();
        this.root.addComponent((BaseComponent)new GuiComponentLabel(85, 50, TranslationUtils.translateToLocal((String)"openblocks.misc.dropper.use_redstone")));
        int sliderSteps = (int)Config.maxItemDropSpeed * 10;
        GuiComponentSlider slider = new GuiComponentSlider(70, 20, 120, 0.0, Config.maxItemDropSpeed, owner.getItemSpeed(), sliderSteps, true, TranslationUtils.translateToLocal((String)"openblocks.misc.dropper.speed"));
        slider.setListener((IValueChangedListener)new IValueChangedListener<Double>(){

            public void valueChanged(Double value) {
                rpc.setItemSpeed(value);
            }
        });
        this.root.addComponent((BaseComponent)slider);
        GuiComponentCheckbox redstoneSwitch = new GuiComponentCheckbox(70, 50, owner.getUseRedstoneStrength());
        redstoneSwitch.setListener((IValueChangedListener)new IValueChangedListener<Boolean>(){

            public void valueChanged(Boolean value) {
                rpc.setUseRedstoneStrength(value);
            }
        });
        this.root.addComponent((BaseComponent)redstoneSwitch);
    }
}

