/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openblocks.common.container.ContainerPaintMixer;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openblocks.rpc.IColorChanger;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.colors.ColorMeta;
import openmods.container.ContainerBase;
import openmods.gui.SyncedGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentColorPicker;
import openmods.gui.component.GuiComponentLevel;
import openmods.gui.component.GuiComponentPalettePicker;
import openmods.gui.component.GuiComponentProgress;
import openmods.gui.component.GuiComponentRect;
import openmods.gui.component.GuiComponentSlider;
import openmods.gui.component.GuiComponentTextButton;
import openmods.gui.component.GuiComponentTextbox;
import openmods.gui.listener.IMouseDownListener;
import openmods.gui.listener.IValueChangedListener;
import openmods.gui.logic.IValueUpdateAction;
import openmods.gui.logic.ValueCopyAction;
import openmods.utils.TranslationUtils;

public class GuiPaintMixer
extends SyncedGuiContainer<ContainerPaintMixer> {
    private static final int CYAN = -11821119;
    private static final int MAGENTA = -2393387;
    private static final int YELLOW = -1579222;
    private static final int KEY = -16777216;
    private int selectedColor;

    public GuiPaintMixer(ContainerPaintMixer container) {
        super((ContainerBase)container, 176, 200, "openblocks.gui.paintmixer");
        TileEntityPaintMixer mixer = (TileEntityPaintMixer)container.getOwner();
        final IColorChanger rpcIntf = mixer.createRpcProxy();
        this.root.addComponent((BaseComponent)new GuiComponentRect(121, 74, 20, 20, -11821119));
        this.root.addComponent((BaseComponent)new GuiComponentRect(141, 74, 20, 20, -2393387));
        this.root.addComponent((BaseComponent)new GuiComponentRect(121, 94, 20, 20, -1579222));
        this.root.addComponent((BaseComponent)new GuiComponentRect(141, 94, 20, 20, -16777216));
        GuiComponentLevel level = new GuiComponentLevel(118, 80, 2, 14, -11821119, -7829368, 0.0f, 2.0f, 0.0f);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(mixer.getDyeSlot(TileEntityPaintMixer.DyeSlot.cyan), (IValueReceiver)level));
        this.root.addComponent((BaseComponent)level);
        level = new GuiComponentLevel(162, 80, 2, 14, -2393387, -7829368, 0.0f, 2.0f, 0.0f);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(mixer.getDyeSlot(TileEntityPaintMixer.DyeSlot.magenta), (IValueReceiver)level));
        this.root.addComponent((BaseComponent)level);
        level = new GuiComponentLevel(118, 100, 2, 14, -1579222, -7829368, 0.0f, 2.0f, 0.0f);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(mixer.getDyeSlot(TileEntityPaintMixer.DyeSlot.yellow), (IValueReceiver)level));
        this.root.addComponent((BaseComponent)level);
        level = new GuiComponentLevel(162, 100, 2, 14, -16777216, -7829368, 0.0f, 2.0f, 0.0f);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(mixer.getDyeSlot(TileEntityPaintMixer.DyeSlot.black), (IValueReceiver)level));
        this.root.addComponent((BaseComponent)level);
        GuiComponentProgress progress = new GuiComponentProgress(125, 43, 300);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(mixer.getProgress(), (IValueReceiver)progress.progressReceiver()));
        this.root.addComponent((BaseComponent)progress);
        GuiComponentTextButton buttonMix = new GuiComponentTextButton(125, 57, 30, 13, 0xFFFFFF);
        buttonMix.setText("Mix").setListener(new IMouseDownListener(){

            public void componentMouseDown(BaseComponent component, int x, int y, int button) {
                rpcIntf.changeColor(GuiPaintMixer.this.selectedColor);
            }
        });
        this.root.addComponent((BaseComponent)buttonMix);
        final GuiComponentTextbox textbox = new GuiComponentTextbox(65, 90, 44, 10);
        this.root.addComponent((BaseComponent)textbox);
        final GuiComponentColorPicker colorPicker = new GuiComponentColorPicker(10, 20);
        this.root.addComponent((BaseComponent)colorPicker);
        final GuiComponentSlider slider = new GuiComponentSlider(10, 75, 100, 0, 255, 0, false);
        this.root.addComponent((BaseComponent)slider);
        final GuiComponentRect colorBox = new GuiComponentRect(10, 90, 45, 10, 0xFFFFFF);
        this.root.addComponent((BaseComponent)colorBox);
        GuiComponentPalettePicker palettePicker = new GuiComponentPalettePicker(112, 25);
        palettePicker.setAreaSize(5);
        palettePicker.setDrawTooltip(true);
        this.root.addComponent((BaseComponent)palettePicker);
        ArrayList vanillaPalette = Lists.newArrayList();
        for (ColorMeta color : ColorMeta.getAllColors()) {
            vanillaPalette.add(new GuiComponentPalettePicker.PaletteEntry(color.vanillaBlockId, color.rgb, TranslationUtils.translateToLocal((String)color.unlocalizedName)));
        }
        palettePicker.setPalette((List)vanillaPalette);
        palettePicker.setListener((IValueChangedListener)new IValueChangedListener<GuiComponentPalettePicker.PaletteEntry>(){

            public void valueChanged(GuiComponentPalettePicker.PaletteEntry value) {
                int rgb = value.rgb;
                GuiPaintMixer.this.selectedColor = rgb;
                textbox.setValue(String.format("%06X", rgb));
                colorBox.setValue(Integer.valueOf(rgb));
                colorPicker.setValue(Integer.valueOf(rgb));
                slider.setValue(Double.valueOf(colorPicker.tone));
            }
        });
        textbox.setListener((IValueChangedListener)new IValueChangedListener<String>(){

            public void valueChanged(String value) {
                try {
                    int parsed = Integer.parseInt(value, 16);
                    GuiPaintMixer.this.selectedColor = parsed;
                    colorPicker.setValue(Integer.valueOf(parsed));
                    slider.setValue(Double.valueOf(colorPicker.tone));
                    colorBox.setValue(Integer.valueOf(parsed));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        colorPicker.setListener((IValueChangedListener)new IValueChangedListener<Integer>(){

            public void valueChanged(Integer value) {
                GuiPaintMixer.this.selectedColor = value;
                textbox.setValue(String.format("%06X", value));
                colorBox.setValue(value);
            }
        });
        slider.setListener((IValueChangedListener)new IValueChangedListener<Double>(){

            public void valueChanged(Double value) {
                colorPicker.tone = value.intValue();
                int color = colorPicker.getColor();
                textbox.setValue(String.format("%06X", color));
                colorBox.setValue(Integer.valueOf(color));
            }
        });
        final IValueProvider<Integer> color = mixer.getColor();
        this.addSyncUpdateListener(new IValueUpdateAction(){

            public Iterable<?> getTriggers() {
                return ImmutableList.of((Object)color);
            }

            public void execute() {
                int value = (Integer)color.getValue();
                GuiPaintMixer.this.selectedColor = value;
                textbox.setValue(String.format("%06X", value));
                colorPicker.setValue(Integer.valueOf(value));
                slider.setValue(Double.valueOf(colorPicker.tone));
                colorBox.setValue(Integer.valueOf(value));
            }
        });
    }
}

