/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import openblocks.common.block.BlockCanvas;
import openblocks.common.sync.SyncableBlockLayers;
import openblocks.common.tileentity.TileEntityCanvas;
import openmods.renderer.FixedRenderBlocks;
import openmods.renderer.IBlockRenderer;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class BlockCanvasRenderer
implements IBlockRenderer<BlockCanvas> {
    public FixedRenderBlocks renderBlocks = new FixedRenderBlocks();

    public void renderInventoryBlock(BlockCanvas block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtils.renderInventoryBlock((RenderBlocks)renderer, (Block)block, (int)0);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockCanvas block, int modelId, RenderBlocks renderer) {
        if (renderer.hasOverrideBlockTexture()) {
            renderer.setRenderBoundsFromBlock((Block)block);
            block.setLayerForRender(-2);
            block.setSideForRender(-1);
            renderer.renderStandardBlock((Block)block, x, y, z);
            return true;
        }
        this.renderBlocks.setWorld(world);
        this.renderBlocks.setRenderBoundsFromBlock((Block)block);
        boolean visible = false;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEntityCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)tile;
            for (int i = 0; i < 6; ++i) {
                this.renderBlocks.setAllFaces(0);
                block.setLayerForRender(-1);
                block.setSideForRender(i);
                if (!this.renderBlocks.renderStandardBlock((Block)block, x, y, z)) continue;
                visible = true;
                SyncableBlockLayers sideLayersContainer = canvas.getLayersForSide(i);
                List layers = sideLayersContainer.getAllLayers();
                for (int l = 0; l < layers.size(); ++l) {
                    block.setLayerForRender(l);
                    int rot = ((SyncableBlockLayers.Layer)layers.get(l)).getRotation();
                    if (rot == 2) {
                        rot = 3;
                    } else if (rot == 3) {
                        rot = 2;
                    }
                    this.renderBlocks.setAllFaces(rot);
                    this.renderBlocks.renderStandardBlock((Block)block, x, y, z);
                }
            }
            RenderUtils.resetFacesOnRenderer((RenderBlocks)this.renderBlocks);
        }
        return visible;
    }
}

