/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import openblocks.common.block.BlockPath;
import openmods.renderer.IBlockRenderer;
import openmods.tileentity.renderer.OpenRenderHelper;
import org.lwjgl.opengl.GL11;

public class BlockPathRenderer
implements IBlockRenderer<BlockPath> {
    private final Random rnd = new Random();

    public void renderInventoryBlock(BlockPath block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.renderWorldBlock(null, 0, 0, 0, block, -1, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockPath block, int modelId, RenderBlocks renderer) {
        HashSet<AxisAlignedBB> boundingBoxes = new HashSet<AxisAlignedBB>();
        for (int i = 0; i < 10; ++i) {
            this.rnd.setSeed((x ^ 0x1F) * (y ^ 0xB) * z ^ i * 113);
            double width = this.rnd.nextDouble() * 0.3 + 0.1;
            double length = this.rnd.nextDouble() * 0.3 + 0.1;
            double pX = this.rnd.nextDouble() * (1.0 - width);
            double pZ = this.rnd.nextDouble() * (1.0 - length);
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)pX, (double)0.0, (double)pZ, (double)(pX + width), (double)1.0, (double)(pZ + length));
            boolean hit = false;
            for (AxisAlignedBB box : boundingBoxes) {
                if (!box.intersectsWith(bb)) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            renderer.setRenderBounds(pX, 0.0, pZ, pX + width, 0.05 * this.rnd.nextDouble() + 0.02, pZ + length);
            if (modelId == -1) {
                OpenRenderHelper.renderCube((double)renderer.renderMinX, (double)renderer.renderMinY, (double)renderer.renderMinZ, (double)renderer.renderMaxX, (double)renderer.renderMaxY, (double)renderer.renderMaxZ, (Block)block, null);
            } else {
                renderer.renderStandardBlock((Block)block, x, y, z);
            }
            boundingBoxes.add(bb);
        }
        return true;
    }
}

