/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import openblocks.Config;
import openblocks.common.block.BlockProjector;
import openmods.renderer.IBlockRenderer;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.ByteUtils;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class BlockProjectorRenderer
implements IBlockRenderer<BlockProjector> {
    private static final float TO_BLOCK_CENTRE = 0.5f;
    private static final int BRIGHTNESS_LEVEL_MAX = 255;
    private static final int BRIGHTNESS_LEVEL_MIN = 0;
    private static final int BRIGHTNESS_LEVEL_DEF = -1;
    private static final float CONE_BEGIN = Config.renderHoloGrid ? 0.0f : 0.25f;
    private static final float CONE_END = Config.renderHoloGrid ? 1.0f : 0.75f;
    private TileEntity renderTe;

    public void renderInventoryBlock(BlockProjector block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)32826);
        boolean depthMaskState = GL11.glGetBoolean((int)2930);
        if (!depthMaskState) {
            GL11.glDepthMask((boolean)true);
        }
        RenderUtils.renderInventoryBlock((RenderBlocks)renderer, (Block)block, (int)0);
        if (block.shouldRenderTesrInInventory()) {
            if (this.renderTe == null) {
                this.renderTe = block.createTileEntityForRender();
            }
            if (this.renderTe instanceof OpenTileEntity) {
                ((OpenTileEntity)this.renderTe).prepareForInventoryRender((Block)block, metadata);
            }
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(this.renderTe, -0.5, -0.5, -0.5, 0.0f);
        }
        if (!depthMaskState) {
            GL11.glDepthMask((boolean)false);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockProjector block, int modelId, RenderBlocks renderer) {
        if (ForgeHooksClient.getWorldRenderPass() == 0) {
            renderer.renderStandardBlock((Block)block, x, y, z);
            return true;
        }
        if (!Config.renderHoloCone) {
            return false;
        }
        if (ForgeHooksClient.getWorldRenderPass() != 1) {
            return false;
        }
        int blockMeta = world.getBlockMetadata(x, y, z);
        if (!ByteUtils.get((int)blockMeta, (int)0)) {
            return false;
        }
        Tessellator tex = Tessellator.instance;
        tex.addTranslation((float)x, (float)y + 0.5f, (float)z);
        if (Config.coneBrightness != -1) {
            tex.setBrightness(Math.max(0, Math.min(Config.coneBrightness, 255)));
        }
        BlockProjectorRenderer.renderCoreWithTex(block.coneIcon, tex);
        tex.addTranslation((float)(-x), -((float)y + 0.5f), (float)(-z));
        return true;
    }

    private static void renderCoreWithTex(IIcon cone, Tessellator tex) {
        float minU = cone.getMinU();
        float minV = cone.getMinV();
        float maxU = cone.getMaxU();
        float maxV = cone.getMaxV();
        BlockProjectorRenderer.renderNorthFace(tex, minU, minV, maxU, maxV);
        BlockProjectorRenderer.renderWestFace(tex, minU, minV, maxU, maxV);
        BlockProjectorRenderer.renderSouthFace(tex, minU, minV, maxU, maxV);
        BlockProjectorRenderer.renderEastFace(tex, minU, minV, maxU, maxV);
    }

    private static void renderNorthFace(Tessellator tex, float minU, float minV, float maxU, float maxV) {
        tex.addVertexWithUV((double)CONE_END, 0.0, 0.25, (double)maxU, (double)maxV);
        tex.addVertexWithUV(1.0, 1.0, 0.0, (double)maxU, (double)minV);
        tex.addVertexWithUV(0.0, 1.0, 0.0, (double)minU, (double)minV);
        tex.addVertexWithUV((double)CONE_BEGIN, 0.0, 0.25, (double)minU, (double)maxV);
        tex.addVertexWithUV((double)CONE_END, 0.0, 0.25, (double)maxU, (double)maxV);
        tex.addVertexWithUV((double)CONE_BEGIN, 0.0, 0.25, (double)minU, (double)maxV);
        tex.addVertexWithUV(0.0, 1.0, 0.0, (double)minU, (double)minV);
        tex.addVertexWithUV(1.0, 1.0, 0.0, (double)maxU, (double)minV);
    }

    private static void renderWestFace(Tessellator tex, float minU, float minV, float maxU, float maxV) {
        tex.addVertexWithUV(0.25, 0.0, (double)CONE_END, (double)maxU, (double)maxV);
        tex.addVertexWithUV(0.0, 1.0, 1.0, (double)maxU, (double)minV);
        tex.addVertexWithUV(0.0, 1.0, 0.0, (double)minU, (double)minV);
        tex.addVertexWithUV(0.25, 0.0, (double)CONE_BEGIN, (double)minU, (double)maxV);
        tex.addVertexWithUV(0.25, 0.0, (double)CONE_END, (double)maxU, (double)maxV);
        tex.addVertexWithUV(0.25, 0.0, (double)CONE_BEGIN, (double)minU, (double)maxV);
        tex.addVertexWithUV(0.0, 1.0, 0.0, (double)minU, (double)minV);
        tex.addVertexWithUV(0.0, 1.0, 1.0, (double)maxU, (double)minV);
    }

    private static void renderEastFace(Tessellator tex, float minU, float minV, float maxU, float maxV) {
        tex.addVertexWithUV(0.75, 0.0, (double)CONE_END, (double)maxU, (double)maxV);
        tex.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)minV);
        tex.addVertexWithUV(1.0, 1.0, 0.0, (double)minU, (double)minV);
        tex.addVertexWithUV(0.75, 0.0, (double)CONE_BEGIN, (double)minU, (double)maxV);
        tex.addVertexWithUV(0.75, 0.0, (double)CONE_END, (double)maxU, (double)maxV);
        tex.addVertexWithUV(0.75, 0.0, (double)CONE_BEGIN, (double)minU, (double)maxV);
        tex.addVertexWithUV(1.0, 1.0, 0.0, (double)minU, (double)minV);
        tex.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)minV);
    }

    private static void renderSouthFace(Tessellator tex, float minU, float minV, float maxU, float maxV) {
        tex.addVertexWithUV((double)CONE_END, 0.0, 0.75, (double)maxU, (double)maxV);
        tex.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)minV);
        tex.addVertexWithUV(0.0, 1.0, 1.0, (double)minU, (double)minV);
        tex.addVertexWithUV((double)CONE_BEGIN, 0.0, 0.75, (double)minU, (double)maxV);
        tex.addVertexWithUV((double)CONE_END, 0.0, 0.75, (double)maxU, (double)maxV);
        tex.addVertexWithUV((double)CONE_BEGIN, 0.0, 0.75, (double)minU, (double)maxV);
        tex.addVertexWithUV(0.0, 1.0, 1.0, (double)minU, (double)minV);
        tex.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)minV);
    }
}

