/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.block.BlockRopeLadder;
import openmods.renderer.IBlockRenderer;

public class BlockRopeLadderRenderer
implements IBlockRenderer<BlockRopeLadder> {
    public void renderInventoryBlock(BlockRopeLadder block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockRopeLadder block, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.instance;
        IIcon icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(0, 0);
        tessellator.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        double um = icon.getMinU();
        double vm = icon.getMinV();
        double up = icon.getMaxU();
        double vp = icon.getMaxV();
        int meta = world.getBlockMetadata(x, y, z);
        ForgeDirection dir = block.getOrientation(meta).north();
        float d = 0.015625f;
        switch (dir) {
            case WEST: {
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 1), (double)(z + 1), um, vm);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 0), (double)(z + 1), um, vp);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 0), (double)(z + 0), up, vp);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 1), (double)(z + 0), up, vm);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 1), (double)(z + 1), um, vm);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 1), (double)(z + 0), up, vm);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 0), (double)(z + 0), up, vp);
                tessellator.addVertexWithUV((double)((float)x + d), (double)(y + 0), (double)(z + 1), um, vp);
                break;
            }
            case EAST: {
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 0), (double)(z + 1), up, vp);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 1), (double)(z + 1), up, vm);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 1), (double)(z + 0), um, vm);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 0), (double)(z + 0), um, vp);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 0), (double)(z + 1), up, vp);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 0), (double)(z + 0), um, vp);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 1), (double)(z + 0), um, vm);
                tessellator.addVertexWithUV((double)((float)(x + 1) - d), (double)(y + 1), (double)(z + 1), up, vm);
                break;
            }
            case NORTH: {
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 0), (double)((float)z + d), up, vp);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 1), (double)((float)z + d), up, vm);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 1), (double)((float)z + d), um, vm);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)((float)z + d), um, vp);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 0), (double)((float)z + d), up, vp);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)((float)z + d), um, vp);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 1), (double)((float)z + d), um, vm);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 1), (double)((float)z + d), up, vm);
                break;
            }
            default: {
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 1), (double)((float)(z + 1) - d), um, vm);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 0), (double)((float)(z + 1) - d), um, vp);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)((float)(z + 1) - d), up, vp);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 1), (double)((float)(z + 1) - d), up, vm);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 1), (double)((float)(z + 1) - d), um, vm);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 1), (double)((float)(z + 1) - d), up, vm);
                tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)((float)(z + 1) - d), up, vp);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 0), (double)((float)(z + 1) - d), um, vp);
            }
        }
        return true;
    }
}

