/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import openblocks.client.renderer.tileentity.tank.INeighbourMap;
import openblocks.common.block.BlockTank;
import openblocks.common.tileentity.TileEntityTank;
import openmods.renderer.DisplayListWrapper;
import openmods.renderer.IBlockRenderer;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class BlockTankRenderer
implements IBlockRenderer<BlockTank> {
    private static final double H = 0.01;
    public static final DisplayListWrapper EMPTY_FRAME = new DisplayListWrapper(){

        public void compile() {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            Tessellator tes = new Tessellator();
            tes.startDrawingQuads();
            tes.setColorOpaque(0, 0, 0);
            tes.setTextureUV(0.0, 0.0);
            BlockTankRenderer.render(tes, INeighbourMap.NO_NEIGHBOURS, 0.0, 0.0, 0.0);
            tes.draw();
            GL11.glEnable((int)3553);
        }
    };

    private static boolean shouldRenderEdgeT(INeighbourMap connections, int d1, int d2) {
        boolean n1 = connections.hasDirectNeighbour(d1);
        boolean n2 = connections.hasDirectNeighbour(d2);
        boolean n12 = connections.hasDiagonalNeighbour(d1, d2);
        return n1 == n2 & !n12;
    }

    private static boolean shouldRenderEdgeB(INeighbourMap connections, int d1, int d2) {
        boolean n1 = connections.hasDirectNeighbour(d1);
        boolean n2 = connections.hasDirectNeighbour(d2);
        boolean n12 = connections.hasDiagonalNeighbour(d1, d2);
        return !n2 & !n1 | n2 & !n12 & n1;
    }

    private static void render(Tessellator tes, INeighbourMap connections, double x, double y, double z) {
        if (BlockTankRenderer.shouldRenderEdgeT(connections, 2, 32)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 1.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 0.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeT(connections, 1, 32)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 0.0), (double)(z + 0.01 + 0.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeB(connections, 2, 16)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 1.0), (double)(z - 0.01 + 1.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeB(connections, 1, 16)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 1.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 0.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeT(connections, 8, 1)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 1.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 0.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeT(connections, 4, 1)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 0.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 0.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeB(connections, 8, 2)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 1.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 1.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeB(connections, 4, 2)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 1.0), (double)(x + 0.01 + 0.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeT(connections, 8, 32)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 1.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 0.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeT(connections, 4, 32)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 0.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 0.0), (double)(y + 0.01 + 0.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeB(connections, 8, 16)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 1.0), (double)(y - 0.01 + 1.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 1.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 1.0));
        }
        if (BlockTankRenderer.shouldRenderEdgeB(connections, 4, 16)) {
            RenderUtils.renderCube((Tessellator)tes, (double)(x - 0.01 + 0.0), (double)(y - 0.01 + 1.0), (double)(z - 0.01 + 0.0), (double)(x + 0.01 + 0.0), (double)(y + 0.01 + 1.0), (double)(z + 0.01 + 1.0));
        }
    }

    public void renderInventoryBlock(BlockTank block, int metadata, int modelID, RenderBlocks renderer) {
        EMPTY_FRAME.render();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockTank block, int modelId, RenderBlocks renderer) {
        if (renderer.hasOverrideBlockTexture()) {
            renderer.setRenderBoundsFromBlock((Block)block);
            renderer.renderStandardBlock((Block)block, x, y, z);
            return true;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        INeighbourMap connections = te instanceof TileEntityTank ? ((TileEntityTank)te).getRenderNeigbourMap() : INeighbourMap.NO_NEIGHBOURS;
        IIcon icon = block.getIcon();
        Tessellator.instance.setTextureUV((double)icon.getMinU(), (double)icon.getMinV());
        Tessellator.instance.setColorOpaque(255, 255, 255);
        BlockTankRenderer.render(Tessellator.instance, connections, x, y, z);
        return true;
    }
}

