/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import openblocks.client.renderer.block.canvas.CanvasState;
import openblocks.client.renderer.block.canvas.InnerBlockState;
import openblocks.client.renderer.block.canvas.StencilModelTransformer;
import openmods.model.BakedModelAdapter;

public class BakedModelCanvas
extends BakedModelAdapter {
    private final StencilModelTransformer modelTransformer;

    public BakedModelCanvas(IBakedModel baseModel, Set<BlockRenderLayer> baseModelLayers, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, VertexFormat vertexFormat) {
        super(baseModel, transforms);
        this.modelTransformer = new StencilModelTransformer(baseModel, baseModelLayers, bakedTextureGetter, vertexFormat);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        Optional<CanvasState> maybeCanvasState;
        Optional<IBlockState> maybeInnerBlock;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            ImmutableMap unlistedProperties = extendedState.getUnlistedProperties();
            maybeInnerBlock = BakedModelCanvas.getProperty(unlistedProperties, InnerBlockState.PROPERTY);
            maybeCanvasState = BakedModelCanvas.getProperty(unlistedProperties, CanvasState.PROPERTY);
            if (maybeCanvasState.isPresent()) {
                ((CanvasState)maybeCanvasState.get()).onRender();
            }
        } else {
            maybeInnerBlock = Optional.absent();
            maybeCanvasState = Optional.absent();
        }
        BlockRenderLayer renderLayer = (BlockRenderLayer)Objects.firstNonNull((Object)MinecraftForgeClient.getRenderLayer(), (Object)BlockRenderLayer.CUTOUT);
        return this.modelTransformer.getQuads(maybeInnerBlock, maybeCanvasState, renderLayer).get(side);
    }

    private static <T> Optional<T> getProperty(ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, IUnlistedProperty<T> prop) {
        return (Optional)unlistedProperties.get(prop);
    }
}

