/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import openblocks.common.item.ItemDevNull;
import openmods.inventory.ItemInventory;
import openmods.renderer.DisplayListWrapper;
import openmods.utils.TextureUtils;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class ItemRendererDevNull
implements IItemRenderer {
    protected static RenderItem itemRenderer = new RenderItem();
    private final ThreadLocal<Counter> counter = new ThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };
    private DisplayListWrapper cube = new DisplayListWrapper(){

        public void compile() {
            IIcon backgroundIcon = ItemDevNull.Icons.iconFull;
            float minU = backgroundIcon.getMinU();
            float minV = backgroundIcon.getMinV();
            float maxV = backgroundIcon.getMaxV();
            float maxU = backgroundIcon.getMaxU();
            Tessellator tes = new Tessellator();
            tes.startDrawingQuads();
            tes.addVertexWithUV(0.0, 0.0, 0.0, (double)minU, (double)minV);
            tes.addVertexWithUV(0.0, 1.0, 0.0, (double)minU, (double)maxV);
            tes.addVertexWithUV(1.0, 1.0, 0.0, (double)maxU, (double)maxV);
            tes.addVertexWithUV(1.0, 0.0, 0.0, (double)maxU, (double)minV);
            tes.addVertexWithUV(0.0, 0.0, 1.0, (double)minU, (double)minV);
            tes.addVertexWithUV(1.0, 0.0, 1.0, (double)minU, (double)maxV);
            tes.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)maxV);
            tes.addVertexWithUV(0.0, 1.0, 1.0, (double)maxU, (double)minV);
            tes.addVertexWithUV(0.0, 0.0, 0.0, (double)minU, (double)minV);
            tes.addVertexWithUV(0.0, 0.0, 1.0, (double)minU, (double)maxV);
            tes.addVertexWithUV(0.0, 1.0, 1.0, (double)maxU, (double)maxV);
            tes.addVertexWithUV(0.0, 1.0, 0.0, (double)maxU, (double)minV);
            tes.addVertexWithUV(1.0, 0.0, 0.0, (double)minU, (double)minV);
            tes.addVertexWithUV(1.0, 1.0, 0.0, (double)minU, (double)maxV);
            tes.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)maxV);
            tes.addVertexWithUV(1.0, 0.0, 1.0, (double)maxU, (double)minV);
            tes.addVertexWithUV(0.0, 0.0, 0.0, (double)minU, (double)minV);
            tes.addVertexWithUV(1.0, 0.0, 0.0, (double)minU, (double)maxV);
            tes.addVertexWithUV(1.0, 0.0, 1.0, (double)maxU, (double)maxV);
            tes.addVertexWithUV(0.0, 0.0, 1.0, (double)maxU, (double)minV);
            tes.addVertexWithUV(0.0, 1.0, 0.0, (double)minU, (double)minV);
            tes.addVertexWithUV(0.0, 1.0, 1.0, (double)minU, (double)maxV);
            tes.addVertexWithUV(1.0, 1.0, 1.0, (double)maxU, (double)maxV);
            tes.addVertexWithUV(1.0, 1.0, 0.0, (double)maxU, (double)minV);
            GL11.glEnable((int)2884);
            GL11.glFrontFace((int)2304);
            GL11.glDisable((int)2896);
            tes.draw();
            GL11.glEnable((int)2896);
            GL11.glFrontFace((int)2305);
        }
    };

    public ItemRendererDevNull() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTextuteChange(TextureStitchEvent evt) {
        if (evt.map.getTextureType() == 1) {
            this.cube.reset();
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack containerStack, Object ... data) {
        if (data.length == 0 || !(data[0] instanceof RenderBlocks)) {
            return;
        }
        Counter counter = this.counter.get();
        if (counter.enter() < 5) {
            ItemInventory inv = new ItemInventory(containerStack, 1);
            ItemStack containedStack = inv.func_70301_a(0);
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                ItemRendererDevNull.renderInventoryStack(containerStack, containedStack);
            } else {
                this.renderInHandStack(type, containerStack, containedStack);
            }
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            ItemRendererDevNull.renderOverload();
        }
        counter.exit();
    }

    private static void renderOverload() {
        RenderUtils.disableLightmap();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        TextureUtils.bindDefaultItemsTexture();
        itemRenderer.renderIcon(0, 0, ItemDevNull.Icons.iconOverload, 16, 16);
    }

    protected void renderInHandStack(IItemRenderer.ItemRenderType type, ItemStack containerStack, ItemStack containedStack) {
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslated((double)-0.25, (double)-0.25, (double)-0.25);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            RenderUtils.disableLightmap();
        }
        TextureUtils.bindDefaultItemsTexture();
        this.cube.render();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            RenderUtils.enableLightmap();
        }
        if (containedStack != null && containedStack.func_77973_b() instanceof ItemBlock) {
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager.instance.itemRenderer.renderItem((EntityLivingBase)mc.field_71439_g, containedStack, 0, IItemRenderer.ItemRenderType.EQUIPPED);
        }
        GL11.glPopMatrix();
    }

    private static void renderInventoryStack(ItemStack containerStack, ItemStack containedStack) {
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        FontRenderer fontRenderer = RenderManager.instance.func_78716_a();
        RenderUtils.disableLightmap();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        TextureUtils.bindDefaultItemsTexture();
        itemRenderer.renderIcon(0, 0, ItemDevNull.Icons.iconTransparent, 16, 16);
        if (fontRenderer != null && containedStack != null) {
            GL11.glPushMatrix();
            RenderHelper.func_74520_c();
            GL11.glScalef((float)0.875f, (float)0.875f, (float)1.0f);
            itemRenderer.renderItemAndEffectIntoGUI(fontRenderer, textureManager, containedStack, 1, 1);
            GL11.glPopMatrix();
            String sizeToRender = containedStack.field_77994_a > 1 ? Integer.toString(containedStack.field_77994_a) : "";
            itemRenderer.renderItemOverlayIntoGUI(fontRenderer, textureManager, containedStack, 0, 0, sizeToRender);
        }
    }

    private static class Counter {
        private int value;

        private Counter() {
        }

        public int enter() {
            return ++this.value;
        }

        public void exit() {
            --this.value;
        }
    }
}

