/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item.devnull;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import openblocks.common.item.ItemDevNull;
import org.apache.commons.lang3.tuple.Pair;

public class DevNullItemOverride
extends ItemOverrideList {
    private static final Matrix4f CENTER_TO_CORNER = new Matrix4f();
    private static final Matrix4f CORNER_TO_CENTER;
    private final TextureAtlasSprite particle;
    private final float scaleFactor2d;
    private final List<List<BakedQuad>> frameQuads2d;
    private final List<IBakedModel> emptyFrameModels2d;
    private final Map<ItemCameraTransforms.TransformType, Matrix4f> transforms2d;
    private final float scaleFactor3d;
    private final List<List<BakedQuad>> frameQuads3d;
    private final List<IBakedModel> emptyFrameModels3d;
    private final Map<ItemCameraTransforms.TransformType, Matrix4f> transforms3d;
    private final LoadingCache<ModelKey, Pair<? extends IBakedModel, Matrix4f>> wrappedModelCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new ModelFactory());

    private static List<BakedQuad> appendScaledModelQuads(List<BakedQuad> output, IBakedModel model, Matrix4f transform, int tintDelta) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            for (BakedQuad quad : model.func_188616_a(null, side, 0L)) {
                output.add(DevNullItemOverride.rescaleQuad(quad, transform, tintDelta));
            }
        }
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            output.add(DevNullItemOverride.rescaleQuad(quad, transform, tintDelta));
        }
        return output;
    }

    private static IBakedModel getItemModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    private static BakedQuad rescaleQuad(BakedQuad quad, Matrix4f transform, int tintDelta) {
        int delta = quad.getFormat().func_181719_f();
        int[] inputVertexData = quad.func_178209_a();
        int[] outputVertexData = Arrays.copyOf(inputVertexData, inputVertexData.length);
        int elementOffset = 0;
        for (int i = 0; i < 4; ++i) {
            float x = Float.intBitsToFloat(inputVertexData[elementOffset + 0]);
            float y = Float.intBitsToFloat(inputVertexData[elementOffset + 1]);
            float z = Float.intBitsToFloat(inputVertexData[elementOffset + 2]);
            Vector4f v = new Vector4f(x, y, z, 1.0f);
            transform.transform((Tuple4f)v);
            outputVertexData[elementOffset + 0] = Float.floatToIntBits(v.x);
            outputVertexData[elementOffset + 1] = Float.floatToIntBits(v.y);
            outputVertexData[elementOffset + 2] = Float.floatToIntBits(v.z);
            elementOffset += delta;
        }
        int tintIndex = quad.func_178212_b() ? quad.func_178211_c() + tintDelta : -1;
        return new BakedQuad(outputVertexData, tintIndex, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    private static Matrix4f scale2d(float scale) {
        Matrix4f result = new Matrix4f();
        result.m00 = result.m11 = scale;
        result.m33 = 1.0f;
        result.m22 = 1.0f;
        return result;
    }

    private static Matrix4f scale3d(float scale) {
        Matrix4f result = new Matrix4f();
        result.m11 = result.m22 = scale;
        result.m00 = result.m22;
        result.m33 = 1.0f;
        return result;
    }

    private static void wrapTransform(Matrix4f inner) {
        inner.mul(CENTER_TO_CORNER);
        inner.mul(CORNER_TO_CENTER, inner);
    }

    private static List<BakedQuad> rescaleModel(IBakedModel model, float scale, boolean is3d) {
        Matrix4f scaleMatrix = is3d ? DevNullItemOverride.scale3d(scale) : DevNullItemOverride.scale2d(scale);
        DevNullItemOverride.wrapTransform(scaleMatrix);
        return DevNullItemOverride.appendScaledModelQuads(Lists.newArrayList(), model, scaleMatrix, 0);
    }

    private static List<List<BakedQuad>> prepareScaledFrames(BakedModelParams params, boolean is3d) {
        ArrayList scaledFrames = Lists.newArrayListWithCapacity((int)6);
        float scale = 1.0f;
        for (int i = 0; i < 5; ++i) {
            scaledFrames.add(DevNullItemOverride.rescaleModel(params.normal, scale, is3d));
            scale *= params.scaleFactor;
        }
        scaledFrames.add(DevNullItemOverride.rescaleModel(params.overflow, scale, is3d));
        return scaledFrames;
    }

    private static List<List<BakedQuad>> composeScaledFrames(List<List<BakedQuad>> scaledFrames) {
        ImmutableList.Builder frames = ImmutableList.builder();
        for (int i = 0; i <= 5; ++i) {
            ImmutableList.Builder nestedFrames = ImmutableList.builder();
            for (int j = 0; j <= i; ++j) {
                nestedFrames.addAll((Iterable)scaledFrames.get(j));
            }
            frames.add((Object)nestedFrames.build());
        }
        return frames.build();
    }

    private List<IBakedModel> prepareFramesBakedModels(List<List<BakedQuad>> scaledFrames, ItemCameraTransforms.TransformType type) {
        ImmutableList.Builder emptyFrameModels = ImmutableList.builder();
        for (int i = 0; i < scaledFrames.size(); ++i) {
            List<BakedQuad> quads = scaledFrames.get(i);
            ModelKey key = new ModelKey(null, i, type);
            emptyFrameModels.add((Object)new BakedDevNull(key, quads, this.particle, true, false));
        }
        return emptyFrameModels.build();
    }

    public DevNullItemOverride(BakedModelParams gui, BakedModelParams world, TextureAtlasSprite particle) {
        super((List)ImmutableList.of());
        this.particle = particle;
        List<List<BakedQuad>> scaledFrames = DevNullItemOverride.prepareScaledFrames(gui, false);
        this.frameQuads2d = DevNullItemOverride.composeScaledFrames(scaledFrames);
        this.emptyFrameModels2d = this.prepareFramesBakedModels(this.frameQuads2d, ItemCameraTransforms.TransformType.GUI);
        this.scaleFactor2d = gui.scaleFactor;
        this.transforms2d = gui.transforms;
        scaledFrames = DevNullItemOverride.prepareScaledFrames(world, true);
        this.frameQuads3d = DevNullItemOverride.composeScaledFrames(scaledFrames);
        this.emptyFrameModels3d = this.prepareFramesBakedModels(this.frameQuads3d, ItemCameraTransforms.TransformType.NONE);
        this.scaleFactor3d = world.scaleFactor;
        this.transforms3d = world.transforms;
    }

    private static void apppendFrameQuads(List<List<BakedQuad>> framesQuads, int depth, ItemCameraTransforms.TransformType transformType, List<BakedQuad> output) {
        List<BakedQuad> frameQuads = framesQuads.get(depth);
        if (transformType == ItemCameraTransforms.TransformType.GUI) {
            for (BakedQuad q : frameQuads) {
                if (q.func_178210_d() != EnumFacing.SOUTH) continue;
                output.add(q);
            }
        } else {
            output.addAll(frameQuads);
        }
    }

    public IBakedModel getEmptyBakedModel() {
        return this.emptyFrameModels2d.get(0);
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        ItemCameraTransforms.TransformType transformType = ItemCameraTransforms.TransformType.NONE;
        Pair<ItemStack, Integer> r = ItemDevNull.getContents(stack);
        int depth = Math.max(1, (Integer)r.getRight());
        if (depth >= 5) {
            return this.emptyFrameModels2d.get(5);
        }
        int modelId = depth - 1;
        ItemStack innerStack = (ItemStack)r.getLeft();
        if (innerStack == null) {
            return this.emptyFrameModels2d.get(modelId);
        }
        IBakedModel innerModel = DevNullItemOverride.getItemModel(innerStack);
        ModelKey key = new ModelKey(innerModel, modelId, transformType);
        return (IBakedModel)((Pair)this.wrappedModelCache.getUnchecked((Object)key)).getLeft();
    }

    private Pair<IBakedModel, Matrix4f> selectEmptyModel(int depth, boolean is2d, ItemCameraTransforms.TransformType transformType) {
        Matrix4f transform = this.getTransform(is2d, transformType);
        IBakedModel model = (is2d ? this.emptyFrameModels2d : this.emptyFrameModels3d).get(depth);
        return Pair.of((Object)model, (Object)transform);
    }

    private Matrix4f getTransform(boolean is2d, ItemCameraTransforms.TransformType transformType) {
        return (is2d ? this.transforms2d : this.transforms3d).get(transformType);
    }

    private Pair<? extends IBakedModel, Matrix4f> getModel(BakedDevNull current, ModelKey key) {
        boolean isGui;
        boolean bl = isGui = key.transform == ItemCameraTransforms.TransformType.GUI;
        if (key.equals(current.key)) {
            return Pair.of((Object)current, (Object)this.getTransform(isGui, key.transform));
        }
        if (key.depth >= 5) {
            return this.selectEmptyModel(5, isGui, key.transform);
        }
        if (key.innerItem == null) {
            return this.selectEmptyModel(key.depth, isGui, key.transform);
        }
        return (Pair)this.wrappedModelCache.getUnchecked((Object)key);
    }

    static {
        CENTER_TO_CORNER.setIdentity();
        DevNullItemOverride.CENTER_TO_CORNER.m23 = -0.5f;
        DevNullItemOverride.CENTER_TO_CORNER.m13 = -0.5f;
        DevNullItemOverride.CENTER_TO_CORNER.m03 = -0.5f;
        CORNER_TO_CENTER = new Matrix4f();
        CORNER_TO_CENTER.setIdentity();
        DevNullItemOverride.CORNER_TO_CENTER.m23 = 0.5f;
        DevNullItemOverride.CORNER_TO_CENTER.m13 = 0.5f;
        DevNullItemOverride.CORNER_TO_CENTER.m03 = 0.5f;
    }

    static class ModelKey {
        public final int depth;
        @Nullable
        public final IBakedModel innerItem;
        public final ItemCameraTransforms.TransformType transform;

        public ModelKey(@Nullable IBakedModel innerItem, int depth, ItemCameraTransforms.TransformType transform) {
            this.innerItem = innerItem;
            this.depth = depth;
            this.transform = transform;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModelKey) {
                ModelKey other = (ModelKey)obj;
                return this.depth == other.depth && Objects.equal((Object)this.innerItem, (Object)other.innerItem) && this.transform == other.transform;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.depth;
            result = 31 * result + (this.innerItem != null ? this.innerItem.hashCode() : 0);
            result = 31 * result + this.transform.hashCode();
            return result;
        }

        public ModelKey update(ItemCameraTransforms.TransformType cameraTransformType) {
            return new ModelKey(this.innerItem, this.depth, cameraTransformType);
        }
    }

    private class ModelFactory
    extends CacheLoader<ModelKey, Pair<? extends IBakedModel, Matrix4f>> {
        private ModelFactory() {
        }

        public Pair<? extends IBakedModel, Matrix4f> load(ModelKey key) throws Exception {
            Matrix4f perspectiveMatrix;
            int depth = key.depth;
            IBakedModel innerModel = key.innerItem;
            Preconditions.checkNotNull((Object)innerModel);
            ItemCameraTransforms.TransformType transformType = key.transform;
            boolean isGui = key.transform == ItemCameraTransforms.TransformType.GUI;
            float scale = (float)Math.pow(isGui ? (double)DevNullItemOverride.this.scaleFactor2d : (double)DevNullItemOverride.this.scaleFactor3d, depth + 1);
            Matrix4f quadTransformMatrix = isGui ? DevNullItemOverride.scale2d(scale) : DevNullItemOverride.scale3d(scale);
            Matrix4f modelTransformMatrix = null;
            if (innerModel instanceof IPerspectiveAwareModel) {
                Pair tmp = ((IPerspectiveAwareModel)innerModel).handlePerspective(key.transform);
                innerModel = (IBakedModel)tmp.getLeft();
                modelTransformMatrix = (Matrix4f)tmp.getRight();
            }
            if (isGui) {
                if (modelTransformMatrix != null) {
                    quadTransformMatrix.mul(modelTransformMatrix);
                }
                perspectiveMatrix = (Matrix4f)DevNullItemOverride.this.transforms2d.get(ItemCameraTransforms.TransformType.GUI);
            } else {
                perspectiveMatrix = modelTransformMatrix;
            }
            DevNullItemOverride.wrapTransform(quadTransformMatrix);
            ArrayList allQuads = Lists.newArrayList();
            DevNullItemOverride.apppendFrameQuads(isGui ? DevNullItemOverride.this.frameQuads2d : DevNullItemOverride.this.frameQuads3d, depth, transformType, allQuads);
            DevNullItemOverride.appendScaledModelQuads(allQuads, innerModel, quadTransformMatrix, 1);
            BakedDevNull model = new BakedDevNull(key, allQuads, DevNullItemOverride.this.particle, innerModel.func_177555_b(), innerModel.func_177556_c());
            return Pair.of((Object)model, (Object)perspectiveMatrix);
        }
    }

    public static class BakedModelParams {
        public final IBakedModel normal;
        public final IBakedModel overflow;
        public final float scaleFactor;
        private Map<ItemCameraTransforms.TransformType, Matrix4f> transforms;

        public BakedModelParams(Map<ItemCameraTransforms.TransformType, Matrix4f> transforms, IBakedModel normal, IBakedModel overflow, float scaleFactor) {
            this.transforms = transforms;
            this.normal = normal;
            this.overflow = overflow;
            this.scaleFactor = scaleFactor;
        }
    }

    private class BakedDevNull
    implements IPerspectiveAwareModel {
        private final ModelKey key;
        private final List<BakedQuad> quads;
        private final TextureAtlasSprite frame;
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;

        public BakedDevNull(ModelKey key, List<BakedQuad> quads, TextureAtlasSprite frame, boolean isAmbientOcclusion, boolean isGui3d) {
            this.key = key;
            this.quads = quads;
            this.frame = frame;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.quads;
        }

        public boolean func_177555_b() {
            return this.isAmbientOcclusion;
        }

        public boolean func_177556_c() {
            return this.isGui3d;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.frame;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return DevNullItemOverride.this;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            ModelKey updatedKey = this.key.update(cameraTransformType);
            return DevNullItemOverride.this.getModel(this, updatedKey);
        }
    }
}

