/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item.devnull;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openblocks.client.renderer.item.devnull.DevNullItemOverride;

public class DevNullModel
implements IRetexturableModel,
IModelCustomData {
    public static final DevNullModel INSTANCE = new DevNullModel();
    private final ModelParams gui;
    private final ModelParams world;
    private final Optional<ResourceLocation> particle;

    public DevNullModel() {
        this(new ModelParams(), new ModelParams(), (Optional<ResourceLocation>)Optional.absent());
    }

    public DevNullModel(ModelParams gui, ModelParams world, Optional<ResourceLocation> particle) {
        this.gui = gui;
        this.world = world;
        this.particle = particle;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Sets.union(this.gui.getDependencies(), this.world.getDependencies());
    }

    public Collection<ResourceLocation> getTextures() {
        return this.particle.asSet();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite particle = (TextureAtlasSprite)bakedTextureGetter.apply(this.particle.or((Object)TextureMap.field_174945_f));
        DevNullItemOverride.BakedModelParams bakedGui = this.gui.bake(state, format, bakedTextureGetter);
        DevNullItemOverride.BakedModelParams bakedWorld = this.world.bake(state, format, bakedTextureGetter);
        DevNullItemOverride override = new DevNullItemOverride(bakedGui, bakedWorld, particle);
        return override.getEmptyBakedModel();
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        Optional<ResourceLocation> newParticle = DevNullModel.tryReplace((String)textures.get((Object)"particle"), this.particle);
        return new DevNullModel(this.gui, this.world, newParticle);
    }

    private static Optional<ResourceLocation> tryReplace(String newTexture, Optional<ResourceLocation> currentTexture) {
        if (newTexture == null) {
            return currentTexture;
        }
        if (newTexture.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new ResourceLocation(newTexture));
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonElement json;
        ModelParams newGui = this.gui;
        ModelParams newWorld = this.world;
        boolean changed = false;
        String data = (String)customData.get((Object)"world");
        if (data != null) {
            json = new JsonParser().parse(data);
            newWorld = newWorld.merge(json.getAsJsonObject());
            changed = true;
        }
        if ((data = (String)customData.get((Object)"gui")) != null) {
            json = new JsonParser().parse(data);
            newGui = newGui.merge(json.getAsJsonObject());
            changed = true;
        }
        return changed ? new DevNullModel(newGui, newWorld, this.particle) : this;
    }

    private static class ModelParams {
        public final Optional<ResourceLocation> normal;
        public final Optional<ResourceLocation> overflow;
        public final float scaleFactor;

        public ModelParams() {
            this((Optional<ResourceLocation>)Optional.absent(), (Optional<ResourceLocation>)Optional.absent(), 0.875f);
        }

        public ModelParams(Optional<ResourceLocation> normal, Optional<ResourceLocation> overflow, float scale) {
            this.normal = normal;
            this.overflow = overflow;
            this.scaleFactor = scale;
        }

        public Set<ResourceLocation> getDependencies() {
            return Sets.union((Set)this.normal.asSet(), (Set)this.overflow.asSet());
        }

        public ModelParams merge(JsonObject obj) {
            String v;
            Optional newNormal = this.normal;
            Optional newOverflow = this.overflow;
            float newScale = this.scaleFactor;
            boolean changed = false;
            if (obj.has("normal")) {
                v = JsonUtils.func_151200_h((JsonObject)obj, (String)"normal");
                newNormal = Optional.of((Object)new ModelResourceLocation(v));
                changed = true;
            }
            if (obj.has("overflow")) {
                v = JsonUtils.func_151200_h((JsonObject)obj, (String)"overflow");
                newOverflow = Optional.of((Object)new ModelResourceLocation(v));
                changed = true;
            }
            if (obj.has("scale")) {
                newScale = JsonUtils.func_151217_k((JsonObject)obj, (String)"scale");
                changed = true;
            }
            return changed ? new ModelParams((Optional<ResourceLocation>)newNormal, (Optional<ResourceLocation>)newOverflow, newScale) : this;
        }

        public DevNullItemOverride.BakedModelParams bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            IModel modelNormal = ModelParams.getModel(this.normal);
            IBakedModel bakedNormal = modelNormal.bake(modelNormal.getDefaultState(), format, bakedTextureGetter);
            IModel modelOveflow = ModelParams.getModel(this.overflow);
            IBakedModel bakedOverflow = modelOveflow.bake(modelOveflow.getDefaultState(), format, bakedTextureGetter);
            IPerspectiveAwareModel transformModel = (IPerspectiveAwareModel)bakedNormal;
            HashMap transforms = Maps.newHashMap();
            for (ItemCameraTransforms.TransformType tt : ItemCameraTransforms.TransformType.values()) {
                transforms.put(tt, transformModel.handlePerspective(tt).getRight());
            }
            return new DevNullItemOverride.BakedModelParams(transforms, bakedNormal, bakedOverflow, this.scaleFactor);
        }

        private static IModel getModel(Optional<ResourceLocation> location) {
            if (location.isPresent()) {
                return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)((ResourceLocation)location.get()), (String)("Couldn't load dependency: " + location.get()));
            }
            return ModelLoaderRegistry.getMissingModel();
        }
    }
}

