/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item.stencil;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openblocks.common.IStencilPattern;
import org.apache.commons.lang3.tuple.Pair;

public class StencilableBitmap {
    private static final int STENCIL_WIDTH = 16;
    private static final int STENCIL_HEIGHT = 16;
    private final PixelCalculator[] pixels;

    public StencilableBitmap(int[] image, int width) {
        int totalPixels = image.length;
        int height = totalPixels / width;
        Preconditions.checkState((width * height == totalPixels ? 1 : 0) != 0, (Object)"Invalid pixel count");
        List<Rectangle> scaledMask = StencilableBitmap.generateScaledMask(width, height);
        List<Rectangle> horizontalMaskStrips = StencilableBitmap.splitHorizontal(scaledMask, width);
        List<Rectangle> fullySplitMask = StencilableBitmap.splitVertical(horizontalMaskStrips, height);
        ArrayList collectedMasks = Lists.newArrayList();
        for (int i = 0; i < totalPixels; ++i) {
            collectedMasks.add(Lists.newArrayList());
        }
        for (Rectangle rect : fullySplitMask) {
            int index = rect.targetY() * width + rect.targetX();
            ((List)collectedMasks.get(index)).add(rect.create());
        }
        this.pixels = new PixelCalculator[totalPixels];
        for (int i = 0; i < totalPixels; ++i) {
            this.pixels[i] = new PixelCalculator(image[i], (List)collectedMasks.get(i));
        }
    }

    private static List<Rectangle> generateScaledMask(int width, int height) {
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        float deltaX = (float)width / 16.0f;
        float deltaY = (float)height / 16.0f;
        int index = 0;
        for (int row = 0; row < 16; ++row) {
            for (int column = 0; column < 16; ++column) {
                float x = deltaX * (float)column;
                float y = deltaY * (float)row;
                result.add(new Rectangle(x, x + deltaX, y, y + deltaY, index++));
            }
        }
        return result;
    }

    private static List<Rectangle> splitHorizontal(List<Rectangle> input, int width) {
        ArrayList result = Lists.newArrayList();
        Iterator<Rectangle> iterator = input.iterator();
        while (iterator.hasNext()) {
            Rectangle r;
            Rectangle reminder = r = iterator.next();
            for (int x = (int)r.left; x < (int)r.right; ++x) {
                Preconditions.checkState((reminder != null ? 1 : 0) != 0, (Object)"Off by one, yell at developer");
                Pair<Rectangle, Rectangle> split = reminder.splitHorizontal(x + 1);
                result.add(split.getLeft());
                reminder = (Rectangle)split.getRight();
            }
            if (reminder == null) continue;
            result.add(reminder);
        }
        return result;
    }

    private static List<Rectangle> splitVertical(List<Rectangle> input, int height) {
        ArrayList result = Lists.newArrayList();
        Iterator<Rectangle> iterator = input.iterator();
        while (iterator.hasNext()) {
            Rectangle r;
            Rectangle reminder = r = iterator.next();
            for (int y = (int)r.top; y < (int)r.bottom; ++y) {
                Preconditions.checkState((reminder != null ? 1 : 0) != 0, (Object)"Off by one, yell at developer");
                Pair<Rectangle, Rectangle> split = reminder.splitVertical(y + 1);
                result.add(split.getLeft());
                reminder = (Rectangle)split.getRight();
            }
            if (reminder == null) continue;
            result.add(reminder);
        }
        return result;
    }

    public int[] apply(IStencilPattern stencil) {
        Preconditions.checkArgument((stencil.width() == 16 ? 1 : 0) != 0, (String)"Invalid stencil width, expected 16, got %s", (Object[])new Object[]{stencil.width()});
        Preconditions.checkArgument((stencil.height() == 16 ? 1 : 0) != 0, (String)"Invalid stencil height, expected 16, got %s", (Object[])new Object[]{stencil.height()});
        int[] result = new int[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            result[i] = this.pixels[i].apply(stencil);
        }
        return result;
    }

    public static class PixelCalculator {
        private final List<MaskWithWeight> modifiers;
        private final float totalWeight;
        private final int originalColor;

        public PixelCalculator(int originalColor, List<MaskWithWeight> inputs) {
            Preconditions.checkState((!inputs.isEmpty() ? 1 : 0) != 0);
            this.modifiers = ImmutableList.copyOf(inputs);
            float totalWeight = 0.0f;
            for (MaskWithWeight w : inputs) {
                totalWeight += w.weight;
            }
            this.totalWeight = totalWeight;
            this.originalColor = originalColor;
        }

        private static float extractChannel(int input, int bits) {
            return input >> bits & 0xFF;
        }

        private static int convertChannel(float input, int bits) {
            int value = Math.min((int)input, 255);
            return value << bits;
        }

        public int apply(IStencilPattern stencil) {
            float c1 = 0.0f;
            float c2 = 0.0f;
            float c3 = 0.0f;
            float c4 = 0.0f;
            for (MaskWithWeight m : this.modifiers) {
                int maskInput = m.convert(stencil, this.originalColor);
                c1 += PixelCalculator.extractChannel(maskInput, 0) * m.weight;
                c2 += PixelCalculator.extractChannel(maskInput, 8) * m.weight;
                c3 += PixelCalculator.extractChannel(maskInput, 16) * m.weight;
                c4 += PixelCalculator.extractChannel(maskInput, 24) * m.weight;
            }
            return PixelCalculator.convertChannel(c1 /= this.totalWeight, 0) | PixelCalculator.convertChannel(c2 /= this.totalWeight, 8) | PixelCalculator.convertChannel(c3 /= this.totalWeight, 16) | PixelCalculator.convertChannel(c4 /= this.totalWeight, 24);
        }
    }

    private static class MaskWithWeight {
        private final float weight;
        private final int bitIndex;

        public MaskWithWeight(float weight, int bitIndex) {
            this.weight = weight;
            this.bitIndex = bitIndex;
        }

        public int convert(IStencilPattern stencil, int background) {
            return stencil.mix(this.bitIndex, 0, background);
        }
    }

    private static class Rectangle {
        private final float left;
        private final float right;
        private final float top;
        private final float bottom;
        private final int bitIndex;

        public Rectangle(float left, float right, float top, float bottom, int bitIndex) {
            Preconditions.checkArgument((right > left ? 1 : 0) != 0);
            Preconditions.checkArgument((bottom > top ? 1 : 0) != 0);
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.bitIndex = bitIndex;
        }

        public Pair<Rectangle, Rectangle> splitHorizontal(int x) {
            Preconditions.checkState(((float)x > this.left && (float)x <= this.right ? 1 : 0) != 0);
            if ((float)x == this.right) {
                return Pair.of((Object)this, null);
            }
            Rectangle left = new Rectangle(this.left, x, this.top, this.bottom, this.bitIndex);
            Rectangle right = new Rectangle(x, this.right, this.top, this.bottom, this.bitIndex);
            return Pair.of((Object)left, (Object)right);
        }

        public Pair<Rectangle, Rectangle> splitVertical(int y) {
            Preconditions.checkState(((float)y > this.top && (float)y <= this.bottom ? 1 : 0) != 0);
            if ((float)y == this.bottom) {
                return Pair.of((Object)this, null);
            }
            Rectangle top = new Rectangle(this.left, this.right, this.top, y, this.bitIndex);
            Rectangle bottom = new Rectangle(this.left, this.right, y, this.bottom, this.bitIndex);
            return Pair.of((Object)top, (Object)bottom);
        }

        public MaskWithWeight create() {
            float width = this.right - this.left;
            float height = this.bottom - this.top;
            float area = width * height;
            return new MaskWithWeight(area, this.bitIndex);
        }

        public int targetX() {
            int result = (int)this.left;
            Preconditions.checkState((this.right <= (float)(result + 1) ? 1 : 0) != 0, (Object)"Rectangle not contained in unit square");
            return result;
        }

        public int targetY() {
            int result = (int)this.top;
            Preconditions.checkState((this.bottom <= (float)(result + 1) ? 1 : 0) != 0, (Object)"Rectangle not contained in unit square");
            return result;
        }
    }
}

