/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.client.model.ModelFlag;
import openblocks.common.tileentity.TileEntityFlag;
import openmods.renderer.DisplayListWrapper;
import openmods.utils.ColorUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityFlagRenderer
extends TileEntitySpecialRenderer {
    private static final ModelFlag POLE = new ModelFlag();
    private static final DisplayListWrapper FLAG = new DisplayListWrapper(){

        public void compile() {
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(1.0, 0.0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(1.0, 1.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0, 0.0, 0.0);
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.addVertexWithUV(0.0, 1.0, -0.001, 0.0, 0.0);
            tessellator.addVertexWithUV(1.0, 1.0, -0.001, 1.0, 0.0);
            tessellator.addVertexWithUV(1.0, 0.0, -0.001, 1.0, 1.0);
            tessellator.addVertexWithUV(0.0, 0.0, -0.001, 0.0, 1.0);
            tessellator.draw();
        }
    };
    private static final ResourceLocation textureFlagpole = new ResourceLocation("openblocks", "textures/models/flagpole.png");
    private static final ResourceLocation textureFlag = new ResourceLocation("openblocks", "textures/models/flag.png");

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        if (!(tileentity instanceof TileEntityFlag)) {
            return;
        }
        TileEntityFlag flag = (TileEntityFlag)tileentity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotatef((float)(-flag.getAngle()), (float)0.0f, (float)1.0f, (float)0.0f);
        if (flag.getOrientation().down() != ForgeDirection.DOWN) {
            GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)-0.7f);
        }
        this.func_147499_a(textureFlagpole);
        POLE.render(f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ColorUtils.RGB color = flag.getColor();
        GL11.glColor3ub((byte)((byte)color.r), (byte)((byte)color.g), (byte)((byte)color.b));
        this.func_147499_a(textureFlag);
        FLAG.render();
        GL11.glPopMatrix();
    }
}

