/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import openblocks.common.block.BlockVillageHighlighter;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openmods.sync.SyncableIntArray;
import org.lwjgl.opengl.GL11;

public class TileEntityVillageHighlighterRenderer
extends TileEntitySpecialRenderer<TileEntityVillageHighlighter> {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(-8.0, -3.0, -8.0, 8.0, 3.0, 8.0);
    private static float N = 1500.0f;

    public void renderTileEntityAt(TileEntityVillageHighlighter vh, double x, double y, double z, float partialTick, int destroyProcess) {
        if (TileEntityVillageHighlighterRenderer.canRender(vh)) {
            int i;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
            Tessellator t = Tessellator.func_178181_a();
            VertexBuffer wr = t.func_178180_c();
            SyncableIntArray villages = vh.getVillageData();
            int[] data = villages.getValue();
            GL11.glPointSize((float)4.0f);
            GL11.glLineWidth((float)10.0f);
            GlStateManager.func_179090_x();
            float off = 2.0f / N;
            float ratio = (float)(Math.PI * (3.0 - Math.sqrt(5.0)));
            wr.func_181668_a(0, DefaultVertexFormats.field_181706_f);
            for (i = 0; i < data.length; i += TileEntityVillageHighlighter.VALUES_PER_VILLAGE) {
                int radius = data[i + 0];
                int vX = data[i + 1];
                int vY = data[i + 2];
                int vZ = data[i + 3];
                int id = data[i + 6];
                int color = id % 0xFFFFFF;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                int j = 0;
                while ((float)j < N) {
                    float py = (float)j * off - 1.0f + off / 2.0f;
                    float rad = (float)Math.sqrt(1.0f - py * py);
                    float phi = (float)j * ratio;
                    float px = MathHelper.func_76134_b((float)phi) * rad;
                    float pz = MathHelper.func_76126_a((float)phi) * rad;
                    wr.func_181662_b((double)((float)vX + px * (float)radius), (double)((float)vY + py * (float)radius), (double)((float)vZ + pz * (float)radius)).func_181666_a(r, g, b, 1.0f).func_181675_d();
                    ++j;
                }
            }
            t.func_78381_a();
            wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            for (i = 0; i < data.length; i += TileEntityVillageHighlighter.VALUES_PER_VILLAGE) {
                int vX = data[i + 1];
                int vY = data[i + 2];
                int vZ = data[i + 3];
                AxisAlignedBB centerBox = BOUNDING_BOX.func_72317_d((double)vX, (double)vY, (double)vZ);
                this.drawBox(wr, centerBox);
            }
            t.func_78381_a();
            GlStateManager.func_179098_w();
            GL11.glPopMatrix();
        }
    }

    private static boolean canRender(TileEntityVillageHighlighter te) {
        if (te == null) {
            return false;
        }
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockVillageHighlighter && (Boolean)state.func_177229_b((IProperty)BlockVillageHighlighter.POWERED) != false;
    }

    private static void addVertex(VertexBuffer wr, double x, double y, double z) {
        wr.func_181662_b(x, y, z).func_181675_d();
    }

    public void drawBox(VertexBuffer wr, AxisAlignedBB bb) {
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        TileEntityVillageHighlighterRenderer.addVertex(wr, bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
    }

    public boolean isGlobalRenderer(TileEntityVillageHighlighter te) {
        return TileEntityVillageHighlighterRenderer.canRender(te);
    }
}

