/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import openblocks.OpenBlocks;
import openblocks.shapes.CoordShape;
import openmods.renderer.shaders.ArraysHelper;
import openmods.renderer.shaders.BufferHelper;
import openmods.renderer.shaders.ShaderProgram;
import openmods.renderer.shaders.ShaderProgramBuilder;

public class MarkerRenderer {
    private static final ResourceLocation vertexSource = OpenBlocks.location("shaders/shader.vert");
    private static final ResourceLocation fragmentSource = OpenBlocks.location("shaders/shader.frag");
    private final ShaderProgram shader;
    private static final int nativeBufferSize = 0x200000;
    private final ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)0x800000);
    private boolean initialized;
    private boolean shouldRefresh;
    private Supplier<VertexBuffer> modelSupplier;
    private int vertexCount;
    private int vao;
    private int vbo;

    public MarkerRenderer() {
        ShaderProgramBuilder shaderProgramBuilder = new ShaderProgramBuilder();
        shaderProgramBuilder.addShader(vertexSource, 35633);
        shaderProgramBuilder.addShader(fragmentSource, 35632);
        this.shader = shaderProgramBuilder.build();
    }

    public void setModel(Supplier<VertexBuffer> modelSupplier) {
        this.modelSupplier = modelSupplier;
        this.shouldRefresh = true;
    }

    private void copyBuffer(ByteBuffer buffer) {
        this.byteBuffer.clear();
        this.byteBuffer.put(buffer);
        this.byteBuffer.flip();
    }

    private void attributePointer(String name, VertexFormat format, int index, VertexFormatElement el) {
        this.shader.attributePointer(name, el.func_177370_d(), el.func_177367_b().func_177397_c(), true, format.func_181719_f() * 4, (long)format.func_181720_d(index));
    }

    private void setupAttributes(VertexFormat format) {
        boolean hasTexture = false;
        boolean hasColor = false;
        List elements = format.func_177343_g();
        block5: for (int i = 0; i < elements.size(); ++i) {
            VertexFormatElement el = (VertexFormatElement)elements.get(i);
            switch (el.func_177375_c()) {
                case COLOR: {
                    this.attributePointer("aColor", format, i, el);
                    hasColor = true;
                    continue block5;
                }
                case POSITION: {
                    this.attributePointer("aVertex", format, i, el);
                    continue block5;
                }
                case UV: {
                    this.attributePointer("aTexCoord", format, i, el);
                    hasTexture = true;
                    continue block5;
                }
            }
        }
        this.shader.uniform1f("uHasTexture", hasTexture ? 1.0f : 0.0f);
        this.shader.uniform1f("uHasColor", hasColor ? 1.0f : 0.0f);
        this.shader.uniform1i("uDefaultTexture", 0);
    }

    private void createVAO() {
        if (this.initialized) {
            Preconditions.checkNotNull(this.modelSupplier, (Object)"Marker model not loaded");
            VertexBuffer vertexBuffer = (VertexBuffer)this.modelSupplier.get();
            ByteBuffer modelByteBuffer = vertexBuffer.func_178966_f();
            if (modelByteBuffer.limit() > 0x200000) {
                throw new UnsupportedOperationException("Big buffers not supported!");
            }
            this.vertexCount = vertexBuffer.func_178989_h();
            this.copyBuffer(modelByteBuffer);
            if (this.vao == 0) {
                this.vao = ArraysHelper.methods().glGenVertexArrays();
            }
            ArraysHelper.methods().glBindVertexArray(this.vao);
            if (this.vbo == 0) {
                this.vbo = BufferHelper.methods().glGenBuffers();
            }
            BufferHelper.methods().glBindBuffer(34962, this.vbo);
            BufferHelper.methods().glBufferData(34962, this.byteBuffer, 35044);
            this.setupAttributes(vertexBuffer.func_178973_g());
            BufferHelper.methods().glBindBuffer(34962, 0);
            ArraysHelper.methods().glBindVertexArray(0);
            this.shouldRefresh = false;
        }
    }

    public void drawInstanced(CoordShape shape, int color, float scale) {
        this.shader.bind();
        this.initialized = true;
        if (this.shouldRefresh) {
            this.createVAO();
        }
        ArraysHelper.methods().glBindVertexArray(this.vao);
        shape.bindVBO();
        this.shader.instanceAttributePointer("aPosition", 3, 5126, false, 0, 0L);
        BufferHelper.methods().glBindBuffer(34962, 0);
        this.shader.uniform3f("uColor", (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        this.shader.uniform1f("uScale", scale);
        ArraysHelper.methods().glDrawArraysInstanced(7, 0, this.vertexCount, shape.size());
        ArraysHelper.methods().glBindVertexArray(0);
        this.shader.release();
    }

    public void deleteShape(CoordShape shape) {
        if (this.initialized) {
            ArraysHelper.methods().glBindVertexArray(this.vao);
            shape.destroy();
            ArraysHelper.methods().glBindVertexArray(0);
        }
    }
}

