/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.api.IElevatorBlock;
import openblocks.common.ElevatorBlockRules;
import openblocks.events.ElevatorActionEvent;
import openmods.movement.PlayerMovementEvent;
import openmods.utils.EnchantmentUtils;

public class ElevatorActionHandler {
    private static boolean canTeleportPlayer(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        if (!Config.irregularBlocksArePassable) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        AxisAlignedBB aabb = blockState.func_185890_d(world, pos);
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private static boolean canTeleportPlayer(EntityPlayer entity, World world, BlockPos pos) {
        AxisAlignedBB aabb = entity.func_174813_aQ();
        double height = Math.abs(aabb.field_72337_e - aabb.field_72338_b);
        int blockHeight = Math.max(1, MathHelper.func_76143_f((double)height));
        for (int dy = 0; dy < blockHeight; ++dy) {
            if (ElevatorActionHandler.canTeleportPlayer(world, pos.func_177981_b(dy))) continue;
            return false;
        }
        return true;
    }

    private static SearchResult findLevel(EntityPlayer player, World world, IBlockState thisBlockState, BlockPos pos, EnumFacing direction) {
        Preconditions.checkArgument((direction == EnumFacing.UP || direction == EnumFacing.DOWN ? 1 : 0) != 0, (Object)"Must be either up or down... for now");
        IElevatorBlock thisElevatorBlock = (IElevatorBlock)thisBlockState.func_177230_c();
        EnumDyeColor thisColor = thisElevatorBlock.getColor(world, pos, thisBlockState);
        int blocksInTheWay = 0;
        BlockPos searchPos = pos;
        block4: for (int i = 0; i < Config.elevatorTravelDistance && world.func_175667_e(searchPos = searchPos.func_177972_a(direction)); ++i) {
            IElevatorBlock otherElevatorBlock;
            EnumDyeColor otherColor;
            if (world.func_175623_d(searchPos)) continue;
            IBlockState blockState = world.func_180495_p(searchPos);
            Block block = blockState.func_177230_c();
            if (block instanceof IElevatorBlock && (otherColor = (otherElevatorBlock = (IElevatorBlock)block).getColor(world, searchPos, blockState)) == thisColor && ElevatorActionHandler.canTeleportPlayer(player, world, searchPos.func_177984_a())) {
                IElevatorBlock.PlayerRotation rotation = otherElevatorBlock.getRotation(world, searchPos, blockState);
                return new SearchResult((Vec3i)searchPos, rotation);
            }
            if (Config.elevatorIgnoreBlocks) continue;
            ElevatorBlockRules.Action action = ElevatorBlockRules.instance.getActionForBlock(blockState);
            switch (action) {
                case ABORT: {
                    return null;
                }
                case IGNORE: {
                    continue block4;
                }
                default: {
                    if (++blocksInTheWay > Config.elevatorMaxBlockPassCount) break block4;
                }
            }
        }
        return null;
    }

    private static void activate(EntityPlayer player, World world, IBlockState state, BlockPos pos, EnumFacing dir) {
        boolean doTeleport;
        SearchResult result = ElevatorActionHandler.findLevel(player, world, state, pos, dir);
        if (result != null && (doTeleport = ElevatorActionHandler.checkXpCost(player, result))) {
            if (result.rotation != IElevatorBlock.PlayerRotation.NONE) {
                player.field_70177_z = ElevatorActionHandler.getYaw(result.rotation);
            }
            if (Config.elevatorCenter) {
                player.func_70634_a((double)result.func_177958_n() + 0.5, (double)result.func_177956_o() + 1.1, (double)result.func_177952_p() + 0.5);
            } else {
                player.func_70634_a(player.field_70165_t, (double)result.func_177956_o() + 1.1, player.field_70161_v);
            }
            world.func_184133_a(null, player.func_180425_c(), OpenBlocks.Sounds.BLOCK_ELEVATOR_ACTIVATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static float getYaw(IElevatorBlock.PlayerRotation rotation) {
        switch (rotation) {
            case EAST: {
                return 90.0f;
            }
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    protected static boolean checkXpCost(EntityPlayer player, SearchResult result) {
        int neededXP;
        int distance = (int)Math.abs(player.field_70163_u - (double)result.func_177956_o());
        if (Config.elevatorXpDrainRatio == 0.0f || player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int playerXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
        if (playerXP >= (neededXP = MathHelper.func_76143_f((double)(Config.elevatorXpDrainRatio * (float)distance)))) {
            EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)(-neededXP));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onElevatorEvent(ElevatorActionEvent evt) {
        World world = evt.getWorld();
        IBlockState blockState = world.func_180495_p(evt.blockPos);
        if (!(blockState.func_177230_c() instanceof IElevatorBlock)) {
            return;
        }
        if (evt.sender != null) {
            if (evt.sender.func_184218_aH()) {
                return;
            }
            switch (evt.type) {
                case JUMP: {
                    ElevatorActionHandler.activate(evt.sender, world, blockState, evt.blockPos, EnumFacing.UP);
                    break;
                }
                case SNEAK: {
                    ElevatorActionHandler.activate(evt.sender, world, blockState, evt.blockPos, EnumFacing.DOWN);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerMovement(PlayerMovementEvent evt) {
        int z;
        int y;
        EntityPlayer player = evt.getEntityPlayer();
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v));
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IElevatorBlock) {
            new ElevatorActionEvent(world.field_73011_w.getDimension(), pos, evt.type).sendToServer();
        }
    }

    private static class SearchResult
    extends BlockPos {
        public final IElevatorBlock.PlayerRotation rotation;

        public SearchResult(Vec3i other, IElevatorBlock.PlayerRotation rotation) {
            super(other);
            this.rotation = rotation;
        }
    }
}

