/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;

public class ElevatorBlockRules {
    public static final ElevatorBlockRules instance = new ElevatorBlockRules();
    private static final Map<String, Action> ACTIONS;
    private Map<Block, Action> rules;

    private ElevatorBlockRules() {
    }

    private Map<Block, Action> getRules() {
        if (this.rules == null) {
            this.rules = Maps.newIdentityHashMap();
            for (String entry : Config.elevatorRules) {
                try {
                    ElevatorBlockRules.tryAddRule(this.rules, entry);
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Invalid entry in map blacklist: %s", (Object[])new Object[]{entry});
                }
            }
        }
        return this.rules;
    }

    private static void tryAddRule(Map<Block, Action> rules, String entry) {
        String[] parts = entry.split(":");
        if (parts.length == 0) {
            return;
        }
        Preconditions.checkState((parts.length == 3 ? 1 : 0) != 0, (Object)"Each entry must have exactly 3 colon-separated fields");
        String modId = parts[0];
        String blockName = parts[1];
        String actionName = parts[2].toLowerCase(Locale.ENGLISH);
        Action action = ACTIONS.get(actionName);
        Preconditions.checkNotNull((Object)((Object)action), (String)"Unknown action: %s", (Object[])new Object[]{actionName});
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modId, blockName));
        if (block != Blocks.field_150350_a) {
            rules.put(block, action);
        } else {
            Log.warn((String)"Can't find block %s", (Object[])new Object[]{entry});
        }
    }

    @SubscribeEvent
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.check("dropblock", "specialBlockRules")) {
            this.rules = null;
        }
    }

    private static boolean isPassable(IBlockState state) {
        return Config.elevatorIgnoreHalfBlocks && !state.func_185915_l();
    }

    public Action getActionForBlock(IBlockState state) {
        Action action = this.getRules().get(state.func_177230_c());
        if (action != null) {
            return action;
        }
        return ElevatorBlockRules.isPassable(state) ? Action.IGNORE : Action.INCREMENT;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Action a : Action.values()) {
            builder.put((Object)a.name().toLowerCase(Locale.ENGLISH), (Object)a);
        }
        ACTIONS = builder.build();
    }

    public static enum Action {
        IGNORE,
        ABORT,
        INCREMENT;

    }
}

