/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemHeightMap;
import openmods.utils.BitSet;

public class MapDataBuilder {
    private static final int LAYER_TERRAIN = 0;
    private static final int LAYER_LIQUIDS = 1;
    private static final int LAYER_COUNT = 2;
    public final int mapId;
    private HeightMapData data;

    public MapDataBuilder(int mapId) {
        this.mapId = mapId;
    }

    public void loadMap(World world) {
        this.data = MapDataManager.getMapData(world, this.mapId);
    }

    public void resetMap(World world, int x, int z) {
        HeightMapData.LayerData ground;
        this.data = MapDataManager.getMapData(world, this.mapId);
        this.data.centerX = x >> 4 << 4;
        this.data.centerZ = z >> 4 << 4;
        this.data.dimension = world.field_73011_w.getDimension();
        if (this.data.layers == null || this.data.layers.length != 2) {
            this.data.layers = new HeightMapData.LayerData[2];
        }
        if ((ground = this.data.layers[0]) == null) {
            this.data.layers[0] = ground = new HeightMapData.LayerData();
        }
        ground.alpha = (byte)-1;
        HeightMapData.LayerData liquid = this.data.layers[1];
        if (liquid == null) {
            this.data.layers[1] = liquid = new HeightMapData.LayerData();
        }
        liquid.alpha = (byte)-128;
        MapDataManager.instance.markDataUpdated(world, this.mapId);
    }

    public Set<ChunkJob> createJobs(BitSet finishedChunks) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Invalid usage, load map first");
        HashMap result = Maps.newHashMap();
        int blocksPerPixel = 1 << this.data.scale;
        int pixelsPerChunk = 16 / blocksPerPixel;
        int chunksPerSide = 64 / pixelsPerChunk;
        int middleChunkX = this.data.centerX >> 4;
        int middleChunkZ = this.data.centerZ >> 4;
        int bitNum = 0;
        int mapX = 0;
        for (int chunkX = middleChunkX - chunksPerSide / 2; chunkX < middleChunkX + chunksPerSide / 2; ++chunkX) {
            int mapY = 0;
            for (int chunkZ = middleChunkZ - chunksPerSide / 2; chunkZ < middleChunkZ + chunksPerSide / 2; ++chunkZ) {
                ChunkPos chunk = new ChunkPos(chunkX, chunkZ);
                if (!finishedChunks.testBit(bitNum)) {
                    result.put(chunk, new ChunkJob(chunk, pixelsPerChunk, mapX, mapY, bitNum));
                }
                ++bitNum;
                mapY += pixelsPerChunk;
            }
            mapX += pixelsPerChunk;
        }
        return Sets.newHashSet(result.values());
    }

    public static ChunkJob doNextChunk(World world, double x, double z, Collection<ChunkJob> jobs) {
        if (jobs.isEmpty()) {
            return null;
        }
        PriorityQueue distances = Queues.newPriorityQueue();
        for (ChunkJob job : jobs) {
            ChunkPos chunk = job.chunk;
            double dx = (double)chunk.func_77273_a() - x;
            double dz = (double)chunk.func_77274_b() - z;
            distances.add(new JobDistance(dx * dx + dz * dz, job));
        }
        IChunkProvider provider = world.func_72863_F();
        while (!distances.isEmpty()) {
            JobDistance dist = (JobDistance)distances.poll();
            ChunkJob job = dist.job;
            ChunkPos chunkCoord = job.chunk;
            Chunk chunk = provider.func_186026_b(chunkCoord.field_77276_a, chunkCoord.field_77275_b);
            if (chunk == null || chunk.func_76621_g()) continue;
            job.mapChunk(world, chunk);
            return job;
        }
        return null;
    }

    public static ItemStack upgradeToMap(World world, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemHeightMap) {
            return stack;
        }
        if (item instanceof ItemEmptyMap) {
            return ItemEmptyMap.upgradeToMap(world, stack);
        }
        throw new IllegalArgumentException("Invalid item type: " + item);
    }

    public int size() {
        return 4 << this.data.scale;
    }

    private int neededBits() {
        int line = this.size();
        return line * line;
    }

    public void resizeIfNeeded(BitSet bitmap) {
        int needed = this.neededBits();
        if (!bitmap.checkSize(needed)) {
            bitmap.resize(needed);
        }
    }

    public void resize(BitSet bitmap) {
        bitmap.resize(this.neededBits());
    }

    private static class JobDistance
    implements Comparable<JobDistance> {
        public final double distance;
        public final ChunkJob job;

        public JobDistance(double distance, ChunkJob job) {
            this.distance = distance;
            this.job = job;
        }

        @Override
        public int compareTo(JobDistance o) {
            return Double.compare(this.distance, o.distance);
        }
    }

    public class ChunkJob {
        public final ChunkPos chunk;
        public final int pixelsPerChunk;
        public final int mapMinX;
        public final int mapMinY;
        public final int bitNum;

        private ChunkJob(ChunkPos chunk, int pixelsPerChunk, int mapMinX, int mapMinY, int bitNum) {
            this.chunk = chunk;
            this.pixelsPerChunk = pixelsPerChunk;
            this.mapMinX = mapMinX;
            this.mapMinY = mapMinY;
            this.bitNum = bitNum;
        }

        private void mapChunk(World world, Chunk chunk) {
            HeightMapData.LayerData ground = ((MapDataBuilder)MapDataBuilder.this).data.layers[0];
            HeightMapData.LayerData liquid = ((MapDataBuilder)MapDataBuilder.this).data.layers[1];
            int blocksPerPixel = 16 / this.pixelsPerChunk;
            int blockInChunkX = 0;
            for (int mapX = this.mapMinX; mapX < this.mapMinX + this.pixelsPerChunk; ++mapX) {
                int blockInChunkZ = 0;
                for (int mapY = this.mapMinY; mapY < this.mapMinY + this.pixelsPerChunk; ++mapY) {
                    BlockCount count = new BlockCount();
                    count.average(world, chunk, blockInChunkX, blockInChunkZ, blocksPerPixel);
                    int index = mapY * 64 + mapX;
                    ground.colorMap[index] = count.groundColor;
                    ground.heightMap[index] = (byte)count.groundHeight;
                    liquid.colorMap[index] = count.liquidColor;
                    liquid.heightMap[index] = (byte)count.liquidHeight;
                    blockInChunkZ += blocksPerPixel;
                }
                blockInChunkX += blocksPerPixel;
            }
            MapDataManager.instance.markDataUpdated(world, MapDataBuilder.this.mapId);
        }
    }

    private static class BlockCount {
        public byte groundColor;
        public int groundHeight;
        public byte liquidColor;
        public int liquidHeight;

        private BlockCount() {
        }

        private static IBlockState getValidBlock(World world, Chunk chunk, BlockPos pos) {
            IBlockState blockState = chunk.func_177435_g(pos);
            Block block = blockState.func_177230_c();
            if (block.isAir(blockState, (IBlockAccess)world, pos)) {
                return null;
            }
            if (blockState.func_185909_g() == MapColor.field_151660_b) {
                return null;
            }
            if (MapDataManager.instance.isBlockTransparent(block)) {
                return null;
            }
            return blockState;
        }

        public void average(World world, Chunk chunk, int startX, int startZ, int size) {
            int i;
            double groundHeightSum = 0.0;
            int[] groundColors = new int[MapColor.field_76281_a.length];
            double liquidHeightSum = 0.0;
            int liquidCount = 0;
            int[] liquidColors = new int[MapColor.field_76281_a.length];
            for (int x = startX; x < startX + size; ++x) {
                for (int z = startZ; z < startZ + size; ++z) {
                    IBlockState blockLiquid = null;
                    BlockPos heightLiquid = null;
                    IBlockState blockSolid = null;
                    BlockPos heightSolid = null;
                    for (int y = 255; y >= 0; --y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState blockState = BlockCount.getValidBlock(world, chunk, pos);
                        if (blockState == null) continue;
                        if (blockState.func_185904_a().func_76224_d()) {
                            if (blockLiquid != null) continue;
                            blockLiquid = blockState;
                            heightLiquid = pos;
                            continue;
                        }
                        blockSolid = blockState;
                        heightSolid = pos;
                        break;
                    }
                    if (blockSolid != null && heightSolid != null) {
                        groundHeightSum += (double)heightSolid.func_177956_o();
                        MapColor color = blockSolid.func_185909_g();
                        int n = color.field_76290_q;
                        groundColors[n] = groundColors[n] + 1;
                    }
                    if (blockLiquid == null || heightLiquid == null) continue;
                    liquidHeightSum += (double)heightLiquid.func_177956_o();
                    MapColor color = blockLiquid.func_185909_g();
                    int n = color.field_76290_q;
                    liquidColors[n] = liquidColors[n] + 1;
                    ++liquidCount;
                }
            }
            int maxColorCount = -1;
            for (i = 0; i < groundColors.length; ++i) {
                if (groundColors[i] <= maxColorCount) continue;
                this.groundColor = (byte)i;
                maxColorCount = groundColors[i];
            }
            this.groundHeight = (int)(groundHeightSum / (double)(size * size));
            if (liquidCount > size * size / 2) {
                maxColorCount = -1;
                for (i = 0; i < liquidColors.length; ++i) {
                    if (liquidColors[i] <= maxColorCount) continue;
                    this.liquidColor = (byte)i;
                    maxColorCount = liquidColors[i];
                }
                this.liquidHeight = (int)(liquidHeightSum / (double)liquidCount);
            }
        }
    }
}

