/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.OpenBlocks;
import openmods.OpenMods;

public class PedometerHandler {
    private static final ResourceLocation CAPABILITY_KEY = OpenBlocks.location("pedometer_state");
    @CapabilityInject(value=PedometerState.class)
    private static final Capability<PedometerState> PEDOMETER_CAPABILITY = null;

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(PedometerState.class, (Capability.IStorage)new Capability.IStorage<PedometerState>(){

            public NBTBase writeNBT(Capability<PedometerState> capability, PedometerState instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<PedometerState> capability, PedometerState instance, EnumFacing side, NBTBase nbt) {
            }
        }, (Callable)new Callable<PedometerState>(){

            @Override
            public PedometerState call() throws Exception {
                return new PedometerState();
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityInjector());
    }

    public static PedometerState getProperty(Entity entity) {
        return (PedometerState)entity.getCapability(PEDOMETER_CAPABILITY, EnumFacing.UP);
    }

    private static class CapabilityInjector {
        private CapabilityInjector() {
        }

        @SubscribeEvent
        public void attachCapability(AttachCapabilitiesEvent<Entity> evt) {
            evt.addCapability(CAPABILITY_KEY, new ICapabilityProvider(){
                private PedometerState state;

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == PEDOMETER_CAPABILITY;
                }

                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    if (capability == PEDOMETER_CAPABILITY) {
                        if (this.state == null) {
                            this.state = new PedometerState();
                        }
                        return (T)this.state;
                    }
                    return null;
                }
            });
        }
    }

    public static class PedometerData {
        public final Vec3d startingPoint;
        public final long totalTime;
        public final double totalDistance;
        public final double straightLineDistance;
        public final double lastCheckDistance;
        public final long lastCheckTime;
        public final double currentSpeed;

        private PedometerData(Vec3d startingPoint, long totalTime, double totalDistance, double straightLineDistance, double lastCheckDistance, long lastCheckTime, double currentSpeed) {
            this.startingPoint = startingPoint;
            this.totalTime = totalTime;
            this.totalDistance = totalDistance;
            this.straightLineDistance = straightLineDistance;
            this.lastCheckDistance = lastCheckDistance;
            this.lastCheckTime = lastCheckTime;
            this.currentSpeed = currentSpeed;
        }

        public double averageSpeed() {
            if (this.totalTime == 0L) {
                return 0.0;
            }
            return this.totalDistance / (double)this.totalTime;
        }

        public double straightLineSpeed() {
            if (this.totalTime == 0L) {
                return 0.0;
            }
            return this.straightLineDistance / (double)this.totalTime;
        }

        public double lastCheckSpeed() {
            if (this.lastCheckTime == 0L) {
                return 0.0;
            }
            return this.lastCheckDistance / (double)this.lastCheckTime;
        }
    }

    public static class PedometerState {
        private double totalDistance;
        private long startTicks;
        private Vec3d startPos;
        private Vec3d prevTickPos;
        private long prevTickTime;
        private Vec3d lastCheckPos;
        private long lastCheckTime;
        private PedometerData lastResult;
        private boolean isRunning;

        public void reset() {
            this.isRunning = false;
            this.totalDistance = 0.0;
            this.lastResult = null;
            this.lastCheckPos = null;
            this.lastCheckTime = 0L;
            this.prevTickPos = null;
            this.prevTickTime = 0L;
        }

        public void init(Entity entity, World world) {
            this.prevTickPos = this.startPos = entity.func_174791_d();
            this.lastCheckPos = this.startPos;
            this.prevTickTime = this.startTicks = OpenMods.proxy.getTicks(world);
            this.lastCheckTime = this.startTicks;
            this.isRunning = true;
        }

        public void update(Entity entity) {
            Vec3d currentPosition = entity.func_174791_d();
            Vec3d deltaSinceLastUpdate = currentPosition.func_178788_d(this.prevTickPos);
            this.prevTickPos = currentPosition;
            long currentTime = OpenMods.proxy.getTicks(entity.field_70170_p);
            double ticksSinceLastUpdate = currentTime - this.prevTickTime;
            this.prevTickTime = currentTime;
            double distanceSinceLastTick = deltaSinceLastUpdate.func_72433_c();
            double currentSpeed = ticksSinceLastUpdate != 0.0 ? distanceSinceLastTick / ticksSinceLastUpdate : 0.0;
            this.totalDistance += distanceSinceLastTick;
            Vec3d deltaFromStart = currentPosition.func_178788_d(this.startPos);
            long ticksFromStart = currentTime - this.startTicks;
            double distanceFromStart = deltaFromStart.func_72433_c();
            double distanceFromLastCheck = 0.0;
            if (this.lastCheckPos != null) {
                distanceFromLastCheck = currentPosition.func_178788_d(this.lastCheckPos).func_72433_c();
            }
            long timeFromLastCheck = currentTime - this.lastCheckTime;
            this.lastResult = new PedometerData(this.startPos, ticksFromStart, this.totalDistance, distanceFromStart, distanceFromLastCheck, timeFromLastCheck, currentSpeed);
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public PedometerData getData() {
            this.lastCheckPos = this.prevTickPos;
            this.lastCheckTime = this.prevTickTime;
            return this.lastResult;
        }
    }
}

