/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import info.openmods.calc.Calculator;
import info.openmods.calc.Environment;
import info.openmods.calc.ExprType;
import info.openmods.calc.SingleExprEvaluator;
import info.openmods.calc.types.fp.DoubleCalculatorFactory;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.item.ItemTrophyBlock;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.trophy.BlazeBehavior;
import openblocks.trophy.CaveSpiderBehavior;
import openblocks.trophy.CreeperBehavior;
import openblocks.trophy.EndermanBehavior;
import openblocks.trophy.GuardianBehavior;
import openblocks.trophy.ITrophyBehavior;
import openblocks.trophy.ItemDropBehavior;
import openblocks.trophy.MooshroomBehavior;
import openblocks.trophy.ShulkerBehavior;
import openblocks.trophy.SkeletonBehavior;
import openblocks.trophy.SnowmanBehavior;
import openblocks.trophy.SquidBehavior;
import openblocks.trophy.WitchBehavior;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openmods.core.fixes.HorseNullFix;
import openmods.reflection.ReflectionHelper;

public class TrophyHandler {
    private static final Map<Trophy, Entity> ENTITY_CACHE = Maps.newHashMap();
    private final Random fallbackDropChance = new Random();
    private final SingleExprEvaluator<Double, ExprType> dropChanceCalculator = SingleExprEvaluator.create((Calculator)DoubleCalculatorFactory.createDefault());

    public TrophyHandler() {
        this.updateDropChanceFormula();
    }

    @SubscribeEvent
    public void onConfigChange(ConfigurationChange.Post evt) {
        if (evt.check("trophy", "trophyDropChanceFormula")) {
            this.updateDropChanceFormula();
        }
    }

    private void updateDropChanceFormula() {
        this.dropChanceCalculator.setExpr((Object)ExprType.INFIX, Config.trophyDropChanceFormula);
        if (!this.dropChanceCalculator.isExprValid()) {
            Log.info((String)"Invalid trophyDropChanceFormula formula: ", (Object[])new Object[]{Config.trophyDropChanceFormula});
        }
    }

    public static Entity getEntityFromCache(Trophy trophy) {
        Entity entity = ENTITY_CACHE.get((Object)trophy);
        if (entity == null) {
            if (!ENTITY_CACHE.containsKey((Object)trophy)) {
                try {
                    entity = trophy.createEntity();
                }
                catch (Throwable t) {
                    Log.severe((Throwable)t, (String)"Failed to create dummy entity for trophy %s", (Object[])new Object[]{trophy});
                }
            }
            ENTITY_CACHE.put(trophy, entity);
        }
        return entity;
    }

    private static Entity setSlimeSize(Entity entity, int size) {
        try {
            ReflectionHelper.call((Object)entity, (String[])new String[]{"func_70799_a", "setSlimeSize"}, (Object[])new Object[]{ReflectionHelper.primitive((int)size)});
        }
        catch (Exception e) {
            Log.warn((Throwable)e, (String)"Can't update slime size", (Object[])new Object[0]);
        }
        return entity;
    }

    @SubscribeEvent
    public void onLivingDrops(final LivingDropsEvent event) {
        Trophy mobTrophy;
        String entityName;
        Double result;
        Entity entity = event.getEntity();
        if (event.isRecentlyHit() && TrophyHandler.canDrop(entity) && (result = (Double)this.dropChanceCalculator.evaluate((SingleExprEvaluator.EnvironmentConfigurator)new SingleExprEvaluator.EnvironmentConfigurator<Double>(){

            public void accept(Environment<Double> env) {
                env.setGlobalSymbol("looting", (Object)event.getLootingLevel());
                env.setGlobalSymbol("chance", (Object)Config.trophyDropChance);
            }
        }, (Supplier)new Supplier<Double>(){

            public Double get() {
                double bias = TrophyHandler.this.fallbackDropChance.nextDouble() / 4.0;
                double selection = TrophyHandler.this.fallbackDropChance.nextDouble();
                return ((double)event.getLootingLevel() + bias) * Config.trophyDropChance - selection;
            }
        })) > 0.0 && !Strings.isNullOrEmpty((String)(entityName = EntityList.func_75621_b((Entity)entity))) && (mobTrophy = Trophy.TYPES.get(entityName)) != null) {
            EntityItem drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, mobTrophy.getItemStack());
            drop.func_174869_p();
            event.getDrops().add(drop);
        }
    }

    private static boolean canDrop(Entity entity) {
        World world = entity.field_70170_p;
        return world != null && world.func_82736_K().func_82766_b("doMobLoot");
    }

    public static enum Trophy {
        Wolf,
        Chicken(new ItemDropBehavior(10000, new ItemStack(Items.field_151110_aK), SoundEvents.field_187665_Y)),
        Cow(new ItemDropBehavior(20000, new ItemStack(Items.field_151116_aA))),
        Creeper(new CreeperBehavior()),
        Skeleton(new SkeletonBehavior()),
        PigZombie(new ItemDropBehavior(20000, new ItemStack(Items.field_151074_bl))),
        Bat(1.0, -0.3),
        Zombie,
        Witch(0.35, new WitchBehavior()),
        Villager,
        Ozelot{

            @Override
            protected Entity createEntity() {
                Entity entity = super.createEntity();
                try {
                    ((EntityOcelot)entity).func_70903_f(true);
                }
                catch (ClassCastException e) {
                    Log.warn((String)"Invalid cat entity class: %s", (Object[])new Object[]{entity.getClass()});
                }
                return entity;
            }
        }
        ,
        Sheep,
        Blaze(new BlazeBehavior()),
        Silverfish,
        Spider,
        CaveSpider(new CaveSpiderBehavior()),
        Slime(0.6){

            @Override
            protected Entity createEntity() {
                return TrophyHandler.setSlimeSize(super.createEntity(), 1);
            }
        }
        ,
        Ghast(0.1, 0.3),
        Enderman(0.3, new EndermanBehavior()),
        LavaSlime(0.6){

            @Override
            protected Entity createEntity() {
                return TrophyHandler.setSlimeSize(super.createEntity(), 1);
            }
        }
        ,
        Squid(0.3, 0.5, new SquidBehavior()),
        MushroomCow(new MooshroomBehavior()),
        VillagerGolem(0.3),
        SnowMan(new SnowmanBehavior()),
        Pig(new ItemDropBehavior(20000, new ItemStack(Items.field_151147_al))),
        Endermite,
        Guardian(new GuardianBehavior()),
        Rabbit(new ItemDropBehavior(20000, new ItemStack(Items.field_151172_bF))),
        PolarBear(new ItemDropBehavior(20000, new ItemStack(Items.field_151115_aP))),
        Shulker(new ShulkerBehavior()),
        EntityHorse(0.35, new ItemDropBehavior(20000, new ItemStack(Items.field_151015_O))){

            @Override
            protected boolean canInstantiate() {
                return HorseNullFix.isWorking();
            }
        };

        private double scale = 0.4;
        private double verticalOffset = 0.0;
        private ITrophyBehavior behavior;
        private boolean instantiationFailed;
        public static final Map<String, Trophy> TYPES;
        public static final Trophy[] VALUES;

        private Trophy() {
        }

        private Trophy(ITrophyBehavior behavior) {
            this.behavior = behavior;
        }

        private Trophy(double scale) {
            this.scale = scale;
        }

        private Trophy(double scale, ITrophyBehavior behavior) {
            this.scale = scale;
            this.behavior = behavior;
        }

        private Trophy(double scale, double verticalOffset) {
            this(scale);
            this.verticalOffset = verticalOffset;
        }

        private Trophy(double scale, double verticalOffset, ITrophyBehavior behavior) {
            this(scale, verticalOffset);
            this.behavior = behavior;
        }

        public double getVerticalOffset() {
            return this.verticalOffset;
        }

        public double getScale() {
            return this.scale;
        }

        public Entity getEntity() {
            return TrophyHandler.getEntityFromCache(this);
        }

        public ItemStack getItemStack() {
            return ItemTrophyBlock.putMetadata(new ItemStack((Block)OpenBlocks.Blocks.trophy), this);
        }

        protected boolean canInstantiate() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playSound(World world, BlockPos pos) {
            if (world == null) {
                return;
            }
            Entity e = this.getEntity();
            if (e instanceof EntityLiving) {
                e.field_70165_t = pos.func_177958_n();
                e.field_70163_u = pos.func_177956_o();
                e.field_70161_v = pos.func_177952_p();
                Entity entity = e;
                synchronized (entity) {
                    e.field_70170_p = world;
                    ((EntityLiving)e).func_70642_aH();
                    e.field_70170_p = null;
                }
            }
        }

        public int executeActivateBehavior(TileEntityTrophy tile, EntityPlayer player) {
            if (this.behavior != null) {
                return this.behavior.executeActivateBehavior(tile, player);
            }
            return 0;
        }

        public void executeTickBehavior(TileEntityTrophy tile) {
            if (this.behavior != null) {
                this.behavior.executeTickBehavior(tile);
            }
        }

        protected Entity createEntity() {
            if (!this.instantiationFailed && this.canInstantiate()) {
                try {
                    return EntityList.func_75620_a((String)this.name(), null);
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Failed to create instance of %s", (Object[])new Object[]{this.name()});
                    this.instantiationFailed = true;
                }
            }
            return null;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Trophy t : Trophy.values()) {
                builder.put((Object)t.name(), (Object)t);
            }
            TYPES = builder.build();
            VALUES = Trophy.values();
        }
    }
}

