/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityBigButton;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockBigButton
extends OpenBlock.SixDirections {
    private static final AxisAlignedBB ACTIVE_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    private static final AxisAlignedBB INACTIVE_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.125, 0.9375);
    public static final IProperty<Boolean> POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final int MASK_ACTIVE = 8;

    public BlockBigButton() {
        super(Material.field_151594_q);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
        this.func_180632_j(this.func_176223_P().func_177226_a(POWERED, (Comparable)Boolean.FALSE));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b(POWERED) != false ? 8 : 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side) && BlockBigButton.isNeighborBlockSolid((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side.func_176734_d());
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean pressed = (Boolean)state.func_177229_b(POWERED);
        Orientation orientation = this.getOrientation(state);
        return BlockSpaceTransform.instance.mapBlockToWorld(orientation, pressed ? ACTIVE_AABB : INACTIVE_AABB);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b(POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean pressed = (Boolean)blockState.func_177229_b(POWERED);
        return side == this.getFront(blockState) && pressed ? 15 : 0;
    }

    private void setPoweredState(World world, BlockPos pos, boolean isPowered) {
        IBlockState state = world.func_180495_p(pos);
        world.func_180501_a(pos, state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        world.func_175685_c(pos, (Block)this);
        EnumFacing rot = this.getBack(state);
        world.func_175685_c(pos.func_177972_a(rot), (Block)this);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            if (playerIn.func_70093_af()) {
                TileEntityBigButton te = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)worldIn, (BlockPos)pos, TileEntityBigButton.class));
                te.openGui(OpenBlocks.instance, playerIn);
            } else if (!((Boolean)state.func_177229_b(POWERED)).booleanValue()) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
                this.setPoweredState(worldIn, pos, true);
                TileEntityBigButton te = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)worldIn, (BlockPos)pos, TileEntityBigButton.class));
                worldIn.func_175684_a(pos, (Block)this, te.getTickTime());
            }
        }
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.setPoweredState(worldIn, pos, false);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }
}

