/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openblocks.Config;
import openmods.block.OpenBlock;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockSponge
extends OpenBlock {
    private static final int TICK_RATE = 100;
    private static final int EVENT_BURN = 123;

    public BlockSponge() {
        super(Material.field_151583_m);
        this.func_149672_a(SoundType.field_185854_g);
        this.setHarvestLevel("axe", 1);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbour) {
        this.clearupLiquid(world, pos);
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.clearupLiquid(world, pos);
        world.func_175684_a(pos, (Block)this, 100 + world.field_73012_v.nextInt(5));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        this.clearupLiquid(world, pos);
        world.func_175684_a(pos, (Block)this, 100 + world.field_73012_v.nextInt(5));
    }

    private void clearupLiquid(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        boolean hitLava = false;
        for (int dx = -Config.spongeRange; dx <= Config.spongeRange; ++dx) {
            for (int dy = -Config.spongeRange; dy <= Config.spongeRange; ++dy) {
                for (int dz = -Config.spongeRange; dz <= Config.spongeRange; ++dz) {
                    BlockPos workPos = pos.func_177982_a(dx, dy, dz);
                    IBlockState state = world.func_180495_p(workPos);
                    Material material = state.func_185904_a();
                    if (!material.func_76224_d()) continue;
                    hitLava |= material == Material.field_151587_i;
                    world.func_175698_g(pos.func_177982_a(dx, dy, dz));
                }
            }
        }
        if (hitLava) {
            world.func_175641_c(pos, (Block)this, 123, 0);
        }
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventId, int eventParam) {
        if (eventId == 123) {
            if (world.field_72995_K) {
                for (int i = 0; i < 20; ++i) {
                    double px = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() * 0.1;
                    double py = (double)pos.func_177956_o() + 1.0 + world.field_73012_v.nextDouble();
                    double pz = (double)pos.func_177952_p() + world.field_73012_v.nextDouble();
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, px, py, pz, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
            return true;
        }
        return super.func_189539_a(state, world, pos, eventId, eventParam);
    }
}

