/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.entity.EntitySmoothMove;
import openmods.utils.NbtUtils;

public abstract class EntityAssistant
extends EntitySmoothMove
implements IEntityAdditionalSpawnData {
    private static final String OWNER_ID_TAG = "OwnerId";
    private UUID ownerId;
    private WeakReference<EntityPlayer> cachedOwner;
    protected double ownerOffsetX;
    protected double ownerOffsetY;
    protected double ownerOffsetZ;

    public EntityAssistant(World world, EntityPlayer owner) {
        super(world);
        this.cachedOwner = new WeakReference<EntityPlayer>(owner);
        if (owner != null) {
            this.ownerId = owner.func_146103_bH().getId();
        }
    }

    public EntityPlayer findOwner() {
        if (this.ownerId == null) {
            return null;
        }
        EntityPlayer result = this.field_70170_p.func_152378_a(this.ownerId);
        if (result != null) {
            this.cachedOwner = new WeakReference<EntityPlayer>(result);
        }
        return result;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_150297_b(OWNER_ID_TAG, 10)) {
            NBTTagCompound ownerTag = tag.func_74775_l(OWNER_ID_TAG);
            this.ownerId = NbtUtils.readUuid((NBTTagCompound)ownerTag);
        } else {
            this.ownerId = null;
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.ownerId != null) {
            tag.func_74782_a(OWNER_ID_TAG, (NBTBase)NbtUtils.store((UUID)this.ownerId));
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer owner = (EntityPlayer)this.cachedOwner.get();
            if (owner == null) {
                owner = this.findOwner();
            }
            if (owner != null) {
                this.smoother.setTarget(owner.field_70165_t + this.ownerOffsetX, owner.field_70163_u + (double)owner.func_70047_e() + this.ownerOffsetY, owner.field_70161_v + this.ownerOffsetZ);
            }
        }
        this.updatePrevPosition();
        this.smoother.update();
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.toItemStack(), 0.5f);
        }
        this.func_70106_y();
        return true;
    }

    public abstract ItemStack toItemStack();

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        return player instanceof EntityPlayerMP && player.func_70093_af() && this.func_70032_d((Entity)player) < 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.ownerId != null) {
            data.writeBoolean(true);
            new PacketBuffer(data).func_179252_a(this.ownerId);
        } else {
            data.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.ownerId = data.readBoolean() ? new PacketBuffer(data).func_179253_g() : null;
    }

    public void setSpawnPosition(Entity owner) {
        this.func_70107_b(owner.field_70165_t + 1.0, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v);
    }
}

