/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.entity.EntityAssistant;
import openblocks.common.entity.EntityCartographer;

public class ItemCartographer
extends Item {
    public ItemCartographer() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> result) {
        for (AssistantType type : AssistantType.VALUES) {
            result.add(new ItemStack((Item)this, 1, type.ordinal()));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        AssistantType type;
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if (!world.field_72995_K && (type = ItemCartographer.getTypeFromItem(stack)) != null) {
            EntityAssistant cartographer = type.createAssistant(world, player, stack);
            world.func_72838_d((Entity)cartographer);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public static AssistantType getTypeFromItem(ItemStack stack) {
        int typeId = stack.func_77952_i();
        if (typeId < 0 || typeId > AssistantType.VALUES.length) {
            typeId = 0;
        }
        return AssistantType.VALUES[typeId];
    }

    public ItemStack createStack(AssistantType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public static enum AssistantType {
        CARTOGRAPHER("cartographer", "cartographer"){

            @Override
            public EntityAssistant createAssistant(World world, EntityPlayer owner, ItemStack stack) {
                return new EntityCartographer(world, owner, stack);
            }
        };

        public final String untranslatedName;
        public static final AssistantType[] VALUES;

        private AssistantType(String name, String iconName) {
            this.untranslatedName = "openblocks.assistant_" + name;
        }

        public abstract EntityAssistant createAssistant(World var1, EntityPlayer var2, ItemStack var3);

        static {
            VALUES = AssistantType.values();
        }
    }
}

