/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.OpenBlocksGuiHandler;
import openmods.infobook.BookDocumentation;
import openmods.inventory.ItemInventory;
import openmods.inventory.PlayerItemInventory;
import openmods.inventory.StackEqualityTesterBuilder;
import org.apache.commons.lang3.tuple.Pair;

@BookDocumentation
public class ItemDevNull
extends Item {
    private static final String BOX_END = "\u255a";
    private static final String BOX_MIDDLE = "\u2551";
    private static final String BOX_START = "\u2554";
    private static final LoadingCache<ItemStack, Pair<ItemStack, Integer>> cache = CacheBuilder.newBuilder().softValues().expireAfterAccess(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ItemStack, Pair<ItemStack, Integer>>(){

        public Pair<ItemStack, Integer> load(ItemStack container) throws Exception {
            int depth;
            ItemStack stack = container;
            for (depth = 0; depth < 5; ++depth) {
                if (stack == null || !(stack.func_77973_b() instanceof ItemDevNull)) {
                    return Pair.of((Object)stack, (Object)depth);
                }
                stack = new ItemInventory(stack, 1).func_70301_a(0);
            }
            return Pair.of(null, (Object)depth);
        }
    });
    public static final int NESTED_ITEM_TINT_DELTA = 1;
    public static final int STACK_LIMIT = 5;
    private static final StackEqualityTesterBuilder.IEqualityTester tester = new StackEqualityTesterBuilder().useItem().useDamage().useNBT().build();

    public ItemDevNull() {
        this.func_77625_d(1);
    }

    public static Pair<ItemStack, Integer> getContents(ItemStack container) {
        if (container == null) {
            return Pair.of(null, (Object)0);
        }
        return (Pair)cache.getUnchecked((Object)container);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!(world.field_72995_K || Config.devNullSneakGui && !player.func_70093_af())) {
            player.openGui((Object)OpenBlocks.instance, OpenBlocksGuiHandler.GuiId.devNull.ordinal(), world, player.field_71071_by.field_70461_c, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item item;
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        PlayerItemInventory inventory = new PlayerItemInventory(player, 1);
        ItemStack containedStack = inventory.func_70301_a(0);
        if (containedStack != null && (item = containedStack.func_77973_b()) instanceof ItemBlock) {
            EnumActionResult response = item.func_180614_a(containedStack, player, world, pos, hand, facing, hitX, hitY, hitZ);
            if (containedStack.field_77994_a == 0) {
                inventory.func_70299_a(0, null);
            } else {
                inventory.func_70299_a(0, containedStack);
            }
            return response;
        }
        return EnumActionResult.PASS;
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent evt) {
        EntityPlayer player = evt.getEntityPlayer();
        ItemStack pickedStack = evt.getItem().func_92059_d();
        if (pickedStack == null || player == null) {
            return;
        }
        boolean foundMatchingContainer = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            int containedItems;
            boolean isMatching;
            ItemInventory inventory;
            ItemStack containedStack;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != this || (containedStack = (inventory = new ItemInventory(stack, 1)).func_70301_a(0)) == null || !(isMatching = tester.isEqual((Object)pickedStack, (Object)containedStack))) continue;
            int totalItems = containedStack.field_77994_a + pickedStack.field_77994_a;
            containedStack.field_77994_a = containedItems = Math.min(containedStack.func_77976_d(), totalItems);
            pickedStack.field_77994_a = Math.max(totalItems - containedItems, 0);
            inventory.func_70299_a(0, containedStack);
            if (pickedStack.field_77994_a == 0) {
                return;
            }
            foundMatchingContainer = true;
        }
        if (foundMatchingContainer) {
            pickedStack.field_77994_a = 0;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Pair<ItemStack, Integer> contents = ItemDevNull.getContents(stack);
        ItemStack containedStack = (ItemStack)contents.getLeft();
        if (containedStack != null) {
            List innerTooltip = containedStack.func_82840_a(playerIn, advanced);
            if (innerTooltip.isEmpty()) {
                tooltip.add(containedStack.field_77994_a + " * " + containedStack.func_82833_r());
            } else {
                innerTooltip.set(0, containedStack.field_77994_a + " * " + (String)innerTooltip.get(0));
                ItemDevNull.box(tooltip, innerTooltip);
            }
        } else if ((Integer)contents.getRight() >= 5) {
            tooltip.add(BOX_START);
            tooltip.add(BOX_MIDDLE + TextFormatting.OBFUSCATED + "WHOOPS" + TextFormatting.RESET);
            tooltip.add(BOX_END);
        }
    }

    private static void box(List<String> output, List<String> input) {
        output.add(BOX_START);
        for (String s : input) {
            output.add(BOX_MIDDLE + s);
        }
        output.add(BOX_END);
    }

    public static class DevNullInventory
    extends PlayerItemInventory {
        private final EntityPlayer player;

        public DevNullInventory(EntityPlayer player, int protectedSlot) {
            super(player, 1, protectedSlot);
            this.player = player;
        }

        public void onInventoryChanged(int slotNumber) {
            super.onInventoryChanged(slotNumber);
            if (!this.player.field_70170_p.field_72995_K && slotNumber == 0) {
                this.checkStack(this.containerStack);
            }
        }

        public boolean func_94041_b(int i, ItemStack stack) {
            return (Integer)ItemDevNull.getContents(stack).getRight() < 5;
        }

        private void checkStack(ItemStack stack) {
            if ((Integer)ItemDevNull.getContents(stack).getRight() >= 5) {
                this.player.func_71029_a((StatBase)OpenBlocks.stackAchievement);
            }
        }
    }

    public static class NestedItemColorHandler
    implements IItemColor {
        private static final int NO_COLOR = -1;
        private final ItemColors itemColors;

        public NestedItemColorHandler(ItemColors itemColors) {
            this.itemColors = itemColors;
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (tintIndex < 1) {
                return -1;
            }
            Pair<ItemStack, Integer> contents = ItemDevNull.getContents(stack);
            if ((Integer)contents.getRight() > 5) {
                return -1;
            }
            ItemStack nestedItem = (ItemStack)contents.getLeft();
            if (nestedItem == null) {
                return -1;
            }
            return this.itemColors.func_186728_a(nestedItem, tintIndex - 1);
        }
    }
}

