/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Optional;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.CanvasReplaceBlacklist;
import openblocks.common.IStencilPattern;
import openblocks.common.StencilPattern;
import openblocks.common.block.BlockCanvas;
import openblocks.common.tileentity.TileEntityCanvas;

public class ItemStencil
extends Item {
    public ItemStencil() {
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> list) {
        for (StencilPattern stencil : StencilPattern.values()) {
            list.add(this.createItemStack(stencil));
        }
    }

    public ItemStack createItemStack(StencilPattern stencil) {
        return new ItemStack((Item)this, 1, stencil.ordinal());
    }

    public static Optional<IStencilPattern> getPattern(ItemStack stack) {
        int patternId = stack.func_77960_j();
        try {
            return Optional.of((Object)StencilPattern.values()[patternId]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Optional.absent();
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (CanvasReplaceBlacklist.instance.isAllowedToReplace(world, pos)) {
            BlockCanvas.replaceBlock(world, pos);
        }
        if ((te = world.func_175625_s(pos)) instanceof TileEntityCanvas) {
            StencilPattern stencil;
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            int stencilId = stack.func_77952_i();
            try {
                stencil = StencilPattern.values()[stencilId];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return EnumActionResult.FAIL;
            }
            if (canvas.useStencil(facing, stencil)) {
                --stack.field_77994_a;
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }
}

