/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.common.TrophyHandler;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;
import openmods.utils.TranslationUtils;

public class ItemTrophyBlock
extends ItemOpenBlock {
    private static final String TAG_ENTITY = "entity";

    public ItemTrophyBlock(Block block) {
        super(block);
    }

    public static TrophyHandler.Trophy getTrophy(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b(TAG_ENTITY)) {
            String entityKey = tag.func_74779_i(TAG_ENTITY);
            return TrophyHandler.Trophy.TYPES.get(entityKey);
        }
        return null;
    }

    public int getMetadata(ItemStack stack) {
        TrophyHandler.Trophy trophy = ItemTrophyBlock.getTrophy(stack);
        return trophy != null ? trophy.ordinal() : 0;
    }

    public static ItemStack putMetadata(ItemStack stack, TrophyHandler.Trophy trophy) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74778_a(TAG_ENTITY, trophy.name());
        return stack;
    }

    public String func_77653_i(ItemStack stack) {
        TrophyHandler.Trophy trophyType = ItemTrophyBlock.getTrophy(stack);
        if (trophyType != null) {
            String name = TranslationUtils.translateToLocal((String)("entity." + trophyType.name() + ".name"));
            return TranslationUtils.translateToLocalFormatted((String)(super.func_77658_a() + ".entity.name"), (Object[])new Object[]{name});
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> result) {
        for (TrophyHandler.Trophy trophy : TrophyHandler.Trophy.VALUES) {
            result.add(ItemTrophyBlock.putMetadata(new ItemStack((Item)this), trophy));
        }
    }
}

