/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openmods.infobook.BookDocumentation;
import org.apache.commons.lang3.ArrayUtils;

@BookDocumentation
public class ItemWrench
extends Item {
    private final Set<Class<? extends Block>> sneakOnly = Sets.newIdentityHashSet();

    public ItemWrench() {
        this.func_77625_d(1);
        this.sneakOnly.add(BlockLever.class);
        this.sneakOnly.add(BlockButton.class);
        this.sneakOnly.add(BlockChest.class);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    private boolean requiresSneaking(final Block block) {
        return Iterables.any(this.sneakOnly, (Predicate)new Predicate<Class<? extends Block>>(){

            public boolean apply(@Nullable Class<? extends Block> input) {
                return input.isInstance(block);
            }
        });
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.requiresSneaking(block) && !player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        Object[] rotations = block.getValidRotations(world, pos);
        if (ArrayUtils.contains((Object[])rotations, (Object)side)) {
            if (world.field_72995_K) {
                return EnumActionResult.PASS;
            }
            if (block.rotateBlock(world, pos, side)) {
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }
}

