/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import openblocks.OpenBlocks;
import openmods.api.IActivateAwareTile;
import openmods.api.IAddAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableUUID;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityBearTrap
extends SyncedTileEntity
implements IActivateAwareTile,
ISurfaceAttachment,
INeighbourAwareTile,
IAddAwareTile,
ITickable {
    public static final int OPENING_ANIMATION_TIME = 15;
    private SyncableFlags flags;
    private SyncableBoolean isLocked;
    private SyncableUUID trappedEntity;
    private int tickSinceOpened;
    private Entity cachedEntity;

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addUpdateListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(TileEntityBearTrap.this.flags) && !TileEntityBearTrap.this.isShut()) {
                    TileEntityBearTrap.this.tickSinceOpened = 0;
                }
            }
        });
    }

    private Entity getEntity() {
        UUID uuid = this.trappedEntity.getValue();
        if (uuid == null) {
            return null;
        }
        if (this.cachedEntity != null && uuid.equals(this.cachedEntity.func_110124_au())) {
            return this.cachedEntity;
        }
        for (Entity entity : this.field_145850_b.field_72996_f) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            this.cachedEntity = entity;
            return entity;
        }
        return null;
    }

    protected void createSyncedFields() {
        this.flags = SyncableFlags.create((int)Flags.values().length);
        this.trappedEntity = new SyncableUUID();
        this.isLocked = new SyncableBoolean();
        this.flags.on((Enum)Flags.isShut);
    }

    public void func_73660_a() {
        ++this.tickSinceOpened;
        if (!this.field_145850_b.field_72995_K) {
            this.immobilizeEntity();
            this.sync();
        }
    }

    private void immobilizeEntity() {
        Entity trappedEntity = this.getEntity();
        if (trappedEntity == null || trappedEntity.field_70128_L) {
            this.open();
            return;
        }
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        trappedEntity.field_82151_R = 0.0f;
        trappedEntity.field_70140_Q = 0.0f;
        trappedEntity.field_70165_t = 0.5 + (double)x;
        trappedEntity.field_70161_v = 0.5 + (double)z;
        trappedEntity.field_70163_u = y;
        trappedEntity.field_70169_q = 0.5 + (double)x;
        trappedEntity.field_70166_s = 0.5 + (double)z;
        trappedEntity.field_70167_r = y;
        trappedEntity.field_70142_S = 0.5 + (double)x;
        trappedEntity.field_70136_U = 0.5 + (double)z;
        trappedEntity.field_70137_T = y;
        trappedEntity.field_70159_w = 0.0;
        trappedEntity.field_70181_x = 0.0;
        trappedEntity.field_70179_y = 0.0;
    }

    public void onEntityCollided(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityCreature && !this.isLocked.get() && this.tickSinceOpened > 15) {
            this.close(entity);
        }
    }

    public boolean isShut() {
        return this.flags.get((Enum)Flags.isShut);
    }

    public int getComparatorLevel() {
        Entity e = this.getEntity();
        return e != null ? MathHelper.func_76143_f((double)(e.func_174813_aQ().func_72320_b() / 16.0)) : 0;
    }

    public int ticksSinceOpened() {
        return this.tickSinceOpened;
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            this.open();
        }
        return true;
    }

    private void close(Entity trapped) {
        if (!this.flags.get((Enum)Flags.isShut)) {
            this.flags.on((Enum)Flags.isShut);
            this.trappedEntity.setValue(trapped.func_110124_au());
            this.playSoundAtBlock(OpenBlocks.Sounds.BLOCK_BEARTRAP_CLOSE, 0.5f, 1.0f);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    private void open() {
        if (this.flags.get((Enum)Flags.isShut)) {
            this.flags.off((Enum)Flags.isShut);
            this.trappedEntity.clear();
            this.playSoundAtBlock(OpenBlocks.Sounds.BLOCK_BEARTRAP_OPEN, 0.5f, 1.0f);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
    }

    public EnumFacing getSurfaceDirection() {
        return EnumFacing.DOWN;
    }

    public void onNeighbourChanged(Block block) {
        this.updateRedstone();
    }

    public void onAdded() {
        this.updateRedstone();
    }

    private void updateRedstone() {
        if (!this.field_145850_b.field_72995_K) {
            boolean isLocked = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
            this.isLocked.set(isLocked);
            if (isLocked) {
                this.open();
            }
        }
    }

    public static enum Flags {
        isShut;

    }
}

