/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import openblocks.OpenBlocks;
import openblocks.api.IPointable;
import openblocks.common.entity.EntityItemProjectile;
import openblocks.rpc.ITriggerable;
import openmods.Log;
import openmods.api.ISurfaceAttachment;
import openmods.sync.SyncableDouble;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.InventoryUtils;
import openmods.utils.render.GeometryUtils;

public class TileEntityCannon
extends SyncedTileEntity
implements IPointable,
ISurfaceAttachment,
ITriggerable,
ITickable {
    private static final int YAW_OFFSET_DEGREES = -90;
    private static final int KNOB_YAW_CHANGE_SPEED = 3;
    private static final int KNOB_PITCH_CHANGE_SPEED = 20;
    private static final int KNOB_VEL_CHANGE_SPEED = 20;
    private static final int KNOB_LOB_MINIMUM_VALUE = 20;
    private static final int KNOB_LOB_MAXIMUM_VALUE = 75;
    private static final int KNOB_LOB_VERTICAL_MUL = 4;
    private static final int KNOB_LOB_HORIZONTAL_MUL = 1;
    private static final int KNOB_LOB_BONUS = 5;
    public SyncableDouble targetPitch;
    public SyncableDouble targetYaw;
    public SyncableDouble targetSpeed;
    public double currentPitch = 45.0;
    public double currentYaw = 0.0;
    private double currentSpeed = 1.4;
    public Vec3d motion;
    public boolean renderLine = true;
    private int ticksSinceLastFire = Integer.MAX_VALUE;
    private Vec3d projectileOrigin = null;

    protected void createSyncedFields() {
        this.targetPitch = new SyncableDouble();
        this.targetYaw = new SyncableDouble();
        this.targetSpeed = new SyncableDouble(1.4);
    }

    public void func_73660_a() {
        this.checkOrigin();
        if (Double.isNaN(this.currentPitch)) {
            Log.warn((String)"Pitch was NaN", (Object[])new Object[0]);
            this.currentPitch = 45.0;
            this.targetPitch.set(this.currentPitch);
        }
        if (Double.isNaN(this.currentYaw)) {
            Log.warn((String)"Yaw was NaN", (Object[])new Object[0]);
            this.currentYaw = 0.0;
        }
        this.currentPitch -= (this.currentPitch - this.targetPitch.get()) / 20.0;
        this.currentYaw = GeometryUtils.normalizeAngle((double)this.currentYaw);
        double targetYaw = GeometryUtils.normalizeAngle((double)this.targetYaw.get());
        if (Math.abs(this.currentYaw - targetYaw) < 3.0) {
            this.currentYaw = targetYaw;
        } else {
            double dist = GeometryUtils.getAngleDistance((double)this.currentYaw, (double)targetYaw);
            this.currentYaw += 3.0 * Math.signum(dist);
        }
        this.currentSpeed -= (this.currentSpeed - this.targetSpeed.get()) / 20.0;
        this.invalidateMotion();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.field_145850_b.func_82737_E() % 20L == 0L && this.field_145850_b.func_175687_A(this.field_174879_c) > 0 && (stack = this.findStack()) != null) {
                this.fireStack(stack);
            }
        } else if (this.ticksSinceLastFire < 100) {
            ++this.ticksSinceLastFire;
        }
    }

    private ItemStack findStack() {
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            IItemHandler inventory = InventoryUtils.tryGetHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(direction), (EnumFacing)direction.func_176734_d());
            if (inventory == null) continue;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.extractItem(i, 64, false);
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    private void fireStack(ItemStack stack) {
        ITriggerable rpc = (ITriggerable)this.createServerRpcProxy(ITriggerable.class, new Class[0]);
        rpc.trigger();
        EntityItemProjectile item = new EntityItemProjectile(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), stack);
        item.func_174869_p();
        Vec3d motion = this.getMotion();
        item.field_70159_w = motion.field_72450_a;
        item.field_70181_x = motion.field_72448_b;
        item.field_70179_y = motion.field_72449_c;
        this.field_145850_b.func_72838_d((Entity)item);
        this.playSoundAtBlock(OpenBlocks.Sounds.BLOCK_CANNON_ACTIVATE, 0.2f, 1.0f);
    }

    @Override
    public void trigger() {
        this.ticksSinceLastFire = 0;
        double pitchRad = Math.toRadians(this.currentYaw - 90.0);
        double x = -0.5 * Math.cos(pitchRad);
        double z = -0.5 * Math.sin(pitchRad);
        for (int i = 0; i < 20; ++i) {
            this.spawnParticle(i < 4 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, x + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.7, z + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int getTicksSinceLastFire() {
        return this.ticksSinceLastFire;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b(32.0, 32.0, 32.0);
    }

    private Vec3d calcMotionFromAngles() {
        double p = Math.toRadians(this.currentPitch);
        double y = Math.toRadians(180.0 - this.currentYaw);
        double sinPitch = Math.sin(p);
        double cosPitch = Math.cos(p);
        double sinYaw = Math.sin(y);
        double cosYaw = Math.cos(y);
        return new Vec3d(-cosPitch * sinYaw * this.currentSpeed, sinPitch * this.currentSpeed, -cosPitch * cosYaw * this.currentSpeed);
    }

    private void invalidateMotion() {
        this.motion = null;
    }

    public Vec3d getMotion() {
        if (this.motion == null) {
            this.motion = this.calcMotionFromAngles();
        }
        return this.motion;
    }

    private void checkOrigin() {
        if (this.projectileOrigin == null) {
            this.projectileOrigin = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.0, 0.5);
        }
    }

    public void setTarget(BlockPos pos) {
        this.checkOrigin();
        Vec3d target = new Vec3d((Vec3i)pos).func_72441_c(0.5, 1.0, 0.5);
        double distHorizontal = 1.0 * Math.sqrt(Math.pow(target.field_72450_a - this.projectileOrigin.field_72450_a, 2.0) + Math.pow(target.field_72449_c - this.projectileOrigin.field_72449_c, 2.0));
        double distVertical = Math.max((target.field_72448_b - this.projectileOrigin.field_72448_b) * 4.0, 0.0);
        float lobScale = (float)Math.min(75.0, Math.max(20.0, 5.0 + distHorizontal + distVertical));
        Vec3d velocity = TileEntityCannonLogic.calculateTrajectory(this.projectileOrigin, target, lobScale);
        double speed = velocity.func_72433_c();
        this.targetSpeed.set(speed);
        Vec3d direction = velocity.func_72432_b();
        double pitch = Math.asin(direction.field_72448_b);
        double yaw = Math.atan2(direction.field_72449_c, direction.field_72450_a);
        this.targetYaw.set(Math.toDegrees(yaw) + -90.0);
        this.targetPitch.set(Math.toDegrees(pitch));
        this.currentYaw = this.targetYaw.get();
        this.currentPitch = this.targetPitch.get();
        this.trySync();
    }

    public void disableLineRender() {
        this.renderLine = false;
    }

    @Override
    public void onPointingStart(ItemStack itemStack, EntityPlayer player) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation("openblocks.misc.selected_cannon", new Object[0]));
    }

    @Override
    public void onPointingEnd(ItemStack itemStack, EntityPlayer player, BlockPos pos) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.pointed_cannon", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        this.setTarget(pos);
    }

    public void setSpeed(double speed) {
        this.targetSpeed.set(speed);
        this.sync();
    }

    public void setPitch(double pitch2) {
        this.targetPitch.set(pitch2);
        this.sync();
    }

    public void setYaw(double yaw2) {
        this.targetYaw.set(yaw2);
        this.sync();
    }

    public EnumFacing getSurfaceDirection() {
        return EnumFacing.DOWN;
    }

    static class TileEntityCannonLogic {
        public static final int HOURS_WASTED_ON_CANNON_LOGIC = 14;
        private static final double PHYS_STEPS_PER_SECOND = 20.0;
        private static final double PHYS_PARTIAL_TIME = 0.05;
        private static final double PHYS_WORLD_GRAVITY = 0.8;
        private static final double PHYS_PARTIAL_WORLD_GRAVITY = 0.04000000000000001;
        private static final double PHYS_PARTIAL_TIME_SQUARE = 0.0025000000000000005;
        private static final Vec3d PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL = new Vec3d(0.0, -1.0000000000000005E-4, 0.0);

        TileEntityCannonLogic() {
        }

        public static Vec3d calculateTrajectory(Vec3d start, Vec3d target, float scale) {
            double n = (double)scale * 20.0;
            double accelerationMultiplier = 0.5 * n * n + n;
            Vec3d scaledAcceleration = new Vec3d(TileEntityCannonLogic.PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL.field_72450_a * accelerationMultiplier, TileEntityCannonLogic.PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL.field_72448_b * accelerationMultiplier, TileEntityCannonLogic.PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL.field_72449_c * accelerationMultiplier);
            double velocityMultiplier = -20.0 / n;
            Vec3d velocity = new Vec3d((start.field_72450_a + scaledAcceleration.field_72450_a - target.field_72450_a) * velocityMultiplier, (start.field_72448_b + scaledAcceleration.field_72448_b - target.field_72448_b) * velocityMultiplier, (start.field_72449_c + scaledAcceleration.field_72449_c - target.field_72449_c) * velocityMultiplier);
            return velocity;
        }
    }
}

