/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiDrawingTable;
import openblocks.common.StencilPattern;
import openblocks.common.container.ContainerDrawingTable;
import openblocks.common.item.ItemStencil;
import openblocks.common.item.MetasGeneric;
import openblocks.rpc.IStencilCrafter;
import openmods.api.ICustomBreakDrops;
import openmods.api.IHasGui;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableEnum;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityDrawingTable
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
IStencilCrafter,
ICustomBreakDrops {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private SyncableEnum<StencilPattern> selectedPattern;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "drawingtable", true, 2){

        public boolean func_94041_b(int slotId, ItemStack itemstack) {
            return itemstack == null || slotId == 0 && MetasGeneric.unpreparedStencil.isA(itemstack);
        }

        public void onInventoryChanged(int slotNumber) {
            if (slotNumber == 0) {
                ItemStack output;
                ItemStack input = this.inventoryContents[0];
                this.inventoryContents[1] = input != null && MetasGeneric.unpreparedStencil.isA(input) ? (output = new ItemStack((Item)OpenBlocks.Items.stencil, input.field_77994_a, ((StencilPattern)TileEntityDrawingTable.this.selectedPattern.get()).ordinal())) : null;
            } else if (slotNumber == 1) {
                ItemStack input;
                ItemStack output = this.inventoryContents[1];
                this.inventoryContents[0] = output != null && output.func_77973_b() instanceof ItemStencil ? (input = MetasGeneric.unpreparedStencil.newItemStack(output.field_77994_a)) : null;
            }
            super.onInventoryChanged(slotNumber);
        }
    });

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addSyncListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(TileEntityDrawingTable.this.selectedPattern)) {
                    TileEntityDrawingTable.this.inventory.onInventoryChanged(0);
                }
            }
        });
    }

    protected void createSyncedFields() {
        this.selectedPattern = SyncableEnum.create((Enum)StencilPattern.CREEPER_FACE);
    }

    @Override
    public void selectionUp() {
        this.selectedPattern.increment();
        this.sync();
    }

    @Override
    public void selectionDown() {
        this.selectedPattern.decrement();
        this.sync();
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerDrawingTable((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiDrawingTable(new ContainerDrawingTable((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public List<ItemStack> getDrops(List<ItemStack> originalDrops) {
        ArrayList drops = Lists.newArrayList();
        drops.add(this.inventory.func_70301_a(0));
        return drops;
    }
}

