/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.api.IActivateAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityGrave
extends SyncedTileEntity
implements IPlaceAwareTile,
IInventoryProvider,
IActivateAwareTile,
ITickable {
    private static final Predicate<EntityLiving> IS_MOB = new Predicate<EntityLiving>(){

        public boolean apply(@Nullable EntityLiving input) {
            return input instanceof IMob;
        }
    };
    private static final String TAG_MESSAGE = "Message";
    private SyncableString perishedUsername;
    private ITextComponent deathMessage;
    private GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("grave", false, 1));

    protected void createSyncedFields() {
        this.perishedUsername = new SyncableString();
    }

    public void func_73660_a() {
        List mobs;
        if (!this.field_145850_b.field_72995_K && Config.spawnSkeletons && this.field_145850_b.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_145850_b.field_73012_v.nextDouble() < Config.skeletonSpawnRate && (mobs = this.field_145850_b.func_175647_a(EntityLiving.class, this.getBB().func_72314_b(7.0, 7.0, 7.0), IS_MOB)).size() < 5) {
            double chance = this.field_145850_b.field_73012_v.nextDouble();
            EntitySkeleton living = chance < 0.5 ? new EntitySkeleton(this.field_145850_b) : new EntityBat(this.field_145850_b);
            living.func_70080_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (living.func_70601_bi()) {
                this.field_145850_b.func_72838_d((Entity)living);
            }
        }
    }

    public String getUsername() {
        return this.perishedUsername.getValue();
    }

    public void setDeathMessage(ITextComponent msg) {
        this.deathMessage = msg.func_150259_f();
    }

    public void setUsername(String username) {
        this.perishedUsername.setValue(username);
    }

    public void setLoot(IInventory invent) {
        this.inventory.clearAndSetSlotCount(invent.func_70302_i_());
        this.inventory.copyFrom(invent);
    }

    public void onBlockPlacedBy(IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.field_145850_b.field_72995_K && placer instanceof EntityPlayer && !(placer instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)placer;
            if (stack.func_82837_s()) {
                this.setUsername(stack.func_82833_r());
            } else {
                this.setUsername(player.func_146103_bH().getName());
            }
            if (player.field_71075_bZ.field_75098_d) {
                this.setLoot((IInventory)player.field_71071_by);
            }
            this.sync();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        if (this.deathMessage != null) {
            String serialized = ITextComponent.Serializer.func_150696_a((ITextComponent)this.deathMessage);
            tag.func_74778_a(TAG_MESSAGE, serialized);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
        String serializedMsg = tag.func_74779_i(TAG_MESSAGE);
        if (!Strings.isNullOrEmpty((String)serializedMsg)) {
            this.deathMessage = ITextComponent.Serializer.func_150699_a((String)serializedMsg);
        }
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BlockUtils.singleBlock((BlockPos)this.field_174879_c);
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.field_70170_p.field_72995_K || hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (held != null && held.func_77973_b().getToolClasses(held).contains("shovel")) {
            this.robGrave(player, held);
        } else if (this.deathMessage != null) {
            player.func_145747_a(this.deathMessage);
        }
        return true;
    }

    protected void robGrave(EntityPlayer player, ItemStack held) {
        boolean dropped = false;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null) continue;
            dropped = true;
            BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (Vec3i)this.field_174879_c, (ItemStack)stack);
        }
        this.inventory.clearAndSetSlotCount(0);
        if (dropped) {
            this.field_145850_b.func_180498_a(null, 2001, this.field_174879_c, Block.func_149682_b((Block)Blocks.field_150346_d));
            if (this.field_145850_b.field_73012_v.nextDouble() < Config.graveSpecialAction) {
                this.ohNoes(player);
            }
            held.func_77972_a(2, (EntityLivingBase)player);
        }
    }

    private void ohNoes(EntityPlayer player) {
        this.field_145850_b.func_184133_a(null, player.func_180425_c(), OpenBlocks.Sounds.BLOCK_GRAVE_ROB, SoundCategory.BLOCKS, 1.0f, 1.0f);
        WorldInfo worldInfo = this.field_145850_b.func_72912_H();
        worldInfo.func_76090_f(700);
        worldInfo.func_76080_g(700);
        worldInfo.func_76069_a(true);
        worldInfo.func_76084_b(true);
    }
}

