/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.block.BlockImaginary;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemImaginationGlasses;
import openmods.OpenMods;
import openmods.api.ICustomPickItem;
import openmods.tileentity.OpenTileEntity;

public class TileEntityImaginary
extends OpenTileEntity
implements ICustomPickItem {
    @SideOnly(value=Side.CLIENT)
    public float visibility;
    public Integer color;
    public boolean isInverted;
    private BlockImaginary.Shape shape;

    public TileEntityImaginary() {
        this.shape = BlockImaginary.Shape.BLOCK;
    }

    public TileEntityImaginary(Integer color, boolean isInverted, BlockImaginary.Shape shape) {
        Preconditions.checkNotNull((Object)((Object)shape), (Object)"Bad idea! Rejected!");
        this.color = color;
        this.isInverted = isInverted;
        this.shape = shape;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readShapeData(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.writeShapeData(tag);
        return tag;
    }

    private void readShapeData(NBTTagCompound tag) {
        this.color = tag.func_74764_b("Color") ? Integer.valueOf(tag.func_74762_e("Color")) : null;
        this.isInverted = tag.func_74767_n("IsInverted");
        if (tag.func_150297_b("Type", 1)) {
            LegacyCollisionData data = LegacyCollisionData.VALUES[tag.func_74771_c("Type")];
            this.shape = data.readFromNBT(tag);
        } else {
            byte shapeId = tag.func_74771_c("Shape");
            this.shape = BlockImaginary.Shape.VALUES[shapeId];
        }
    }

    private NBTTagCompound writeShapeData(NBTTagCompound tag) {
        if (this.color != null) {
            tag.func_74768_a("Color", this.color.intValue());
        }
        tag.func_74757_a("IsInverted", this.isInverted);
        tag.func_74774_a("Shape", (byte)this.shape.ordinal());
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 42, this.writeShapeData(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readShapeData(pkt.func_148857_g());
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean isPencil() {
        return this.color == null;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public boolean is(Property what, EntityPlayer player) {
        if (what == Property.VISIBLE && player.func_175149_v()) {
            return true;
        }
        if (what == Property.SOLID && this.isPencil()) {
            return true;
        }
        ItemStack helmet = player.field_71071_by.func_70440_f(3);
        if (helmet == null) {
            return this.isInverted();
        }
        Item item = helmet.func_77973_b();
        if (item instanceof ItemImaginationGlasses) {
            return ((ItemImaginationGlasses)item).checkBlock(what, helmet, this);
        }
        return this.isInverted();
    }

    public boolean is(Property what, Entity e) {
        return e instanceof EntityPlayer && this.is(what, (EntityPlayer)e);
    }

    public boolean is(Property what) {
        EntityPlayer player = OpenMods.proxy.getThePlayer();
        return player != null && this.is(what, player);
    }

    public ItemStack getPickBlock(EntityPlayer player) {
        int dmg = this.isPencil() ? 0 : 1;
        return ItemImaginary.setupValues(new ItemStack(this.func_145838_q(), 1, dmg), this.color, this.shape, this.isInverted);
    }

    public BlockImaginary.Shape getShape() {
        return this.shape;
    }

    public BlockImaginary.Type getType() {
        return this.isPencil() ? BlockImaginary.Type.PENCIL : BlockImaginary.Type.CRAYON;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public static interface ILegacyCollisionData {
        public BlockImaginary.Shape readFromNBT(NBTTagCompound var1);
    }

    public static enum LegacyCollisionData {
        BLOCK{

            @Override
            public BlockImaginary.Shape readFromNBT(NBTTagCompound tag) {
                return BlockImaginary.Shape.BLOCK;
            }
        }
        ,
        PANEL{

            @Override
            public BlockImaginary.Shape readFromNBT(NBTTagCompound tag) {
                float height = tag.func_74760_g("PanelHeight");
                return (double)height < 0.75 ? BlockImaginary.Shape.HALF_PANEL : BlockImaginary.Shape.PANEL;
            }
        }
        ,
        STAIRS{

            @Override
            public BlockImaginary.Shape readFromNBT(NBTTagCompound tag) {
                return BlockImaginary.Shape.STAIRS;
            }
        };

        public static final LegacyCollisionData[] VALUES;

        public abstract BlockImaginary.Shape readFromNBT(NBTTagCompound var1);

        static {
            VALUES = LegacyCollisionData.values();
        }
    }

    public static enum Property {
        VISIBLE,
        SELECTABLE,
        SOLID;

    }
}

