/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiProjector;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.block.BlockProjector;
import openblocks.common.container.ContainerProjector;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemHeightMap;
import openblocks.rpc.IRotatable;
import openmods.OpenMods;
import openmods.api.IHasGui;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityProjector
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
ISyncListener,
IRotatable {
    private final GenericInventory inventory = new TileEntityInventory((TileEntity)this, "openblocks.projector", false, 1){

        public boolean func_94041_b(int i, ItemStack stack) {
            if (stack == null) {
                return false;
            }
            Item item = stack.func_77973_b();
            return item instanceof ItemHeightMap || item instanceof ItemEmptyMap;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void onInventoryChanged(int slotNumber) {
            super.onInventoryChanged(slotNumber);
            if (!TileEntityProjector.this.func_145837_r()) {
                if (!((TileEntityProjector)TileEntityProjector.this).field_145850_b.field_72995_K) {
                    ItemStack stack = this.func_70301_a(slotNumber);
                    if (stack != null && stack.field_77994_a == 1) {
                        Item item = stack.func_77973_b();
                        if (item instanceof ItemHeightMap) {
                            int mapId = stack.func_77952_i();
                            TileEntityProjector.this.mapId.set(mapId);
                        } else if (item instanceof ItemEmptyMap && TileEntityProjector.this.field_145850_b != null) {
                            ItemStack newStack = ItemEmptyMap.upgradeToMap(TileEntityProjector.this.field_145850_b, stack);
                            this.func_70299_a(slotNumber, newStack);
                        } else {
                            TileEntityProjector.this.mapId.set(-1);
                        }
                    } else {
                        TileEntityProjector.this.mapId.set(-1);
                    }
                    TileEntityProjector.this.sync();
                    boolean isActive = TileEntityProjector.this.mapId() >= 0;
                    BlockPos pos = TileEntityProjector.this.func_174877_v();
                    IBlockState oldState = TileEntityProjector.this.field_145850_b.func_180495_p(pos);
                    IBlockState newState = oldState.func_177226_a((IProperty)BlockProjector.ACTIVE, (Comparable)Boolean.valueOf(isActive));
                    if (oldState != newState) {
                        TileEntityProjector.this.field_145850_b.func_180501_a(pos, newState, 3);
                    }
                }
                TileEntityProjector.this.markUpdated();
            }
        }
    };
    private final IAnimationStateMachine asm;
    private final TimeValues.VariableValue lastChange = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);
    private SyncableByte rotation;
    private SyncableInt mapId;

    public TileEntityProjector() {
        this.asm = OpenMods.proxy.loadAsm(OpenBlocks.location("asms/block/projector.json"), ImmutableMap.of((Object)"last_change", (Object)this.lastChange));
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addUpdateListener((ISyncListener)this);
    }

    protected void createSyncedFields() {
        this.rotation = new SyncableByte();
        this.mapId = new SyncableInt(-1);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return BlockUtils.expandAround((BlockPos)this.field_174879_c, (int)1, (int)5, (int)1);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerProjector((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiProjector(new ContainerProjector((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void onSync(Set<ISyncableObject> changes) {
        int mapId;
        if (changes.contains(this.mapId) && (mapId = this.mapId.get()) >= 0 && MapDataManager.getMapData(this.field_145850_b, mapId).isEmpty()) {
            MapDataManager.requestMapData(this.field_145850_b, mapId);
        }
    }

    @Override
    public void rotate(int delta) {
        int value = this.rotation.get() + delta;
        this.rotation.set((byte)(value & 3));
        this.sync();
    }

    public byte rotation() {
        return this.rotation.get();
    }

    public int mapId() {
        return this.mapId.get();
    }

    public HeightMapData getMap() {
        int mapId = this.mapId.get();
        if (this.field_145850_b == null || mapId < 0) {
            return null;
        }
        return MapDataManager.getMapData(this.field_145850_b, mapId);
    }

    public void markMapDirty() {
        int mapId = this.mapId.get();
        if (this.field_145850_b != null || mapId < 0) {
            MapDataManager.instance.markDataUpdated(this.field_145850_b, mapId);
        }
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == CapabilityAnimation.ANIMATION_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)this.asm;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getHandler();
        }
        return (T)super.getCapability(capability, side);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateAsmState();
    }

    public void onLoad() {
        super.onLoad();
        this.updateAsmState();
    }

    private void updateAsmState() {
        if (this.asm != null && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)BlockProjector.ACTIVE)).booleanValue()) {
                if (this.asm.currentState().equals("default")) {
                    this.updateLastChangeTime();
                    this.asm.transition("starting");
                }
            } else if (this.asm.currentState().equals("moving")) {
                this.updateLastChangeTime();
                this.asm.transition("stopping");
            }
        }
    }

    private void updateLastChangeTime() {
        this.lastChange.setValue(Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime()));
    }
}

