/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.Village;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockVillageHighlighter;
import openmods.OpenMods;
import openmods.sync.SyncableIntArray;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityVillageHighlighter
extends SyncedTileEntity
implements ITickable {
    public static int VALUES_PER_VILLAGE = 7;
    private SyncableIntArray villageData;
    private boolean previousBreedStatus = false;

    protected void createSyncedFields() {
        this.villageData = new SyncableIntArray();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && OpenMods.proxy.getTicks(this.field_145850_b) % 10L == 0L && this.isEnabled()) {
            ArrayList tmpDataList = Lists.newArrayList();
            for (Village village : this.field_145850_b.field_72982_D.func_75540_b()) {
                if (!village.func_179866_a(this.field_174879_c)) continue;
                tmpDataList.add(village.func_75568_b());
                BlockPos d = village.func_180608_a().func_177973_b((Vec3i)this.field_174879_c);
                tmpDataList.add(d.func_177958_n());
                tmpDataList.add(d.func_177956_o());
                tmpDataList.add(d.func_177952_p());
                tmpDataList.add(village.func_75567_c());
                tmpDataList.add(village.func_75562_e());
                tmpDataList.add(System.identityHashCode(village));
            }
            this.villageData.setValue(Ints.toArray((Collection)tmpDataList));
            this.sync();
            boolean canBreed = this.canVillagersBreed();
            if (this.previousBreedStatus != canBreed) {
                this.field_145850_b.func_175685_c(this.field_174879_c, (Block)OpenBlocks.Blocks.villageHighlighter);
                this.previousBreedStatus = canBreed;
            }
        }
    }

    private boolean isEnabled() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockVillageHighlighter && (Boolean)state.func_177229_b((IProperty)BlockVillageHighlighter.POWERED) != false;
    }

    public SyncableIntArray getVillageData() {
        return this.villageData;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(200.0, 200.0, 200.0);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean canVillagersBreed() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        for (Village village : this.field_145850_b.field_72982_D.func_75540_b()) {
            if (!village.func_179866_a(this.field_174879_c)) continue;
            int i = (int)((double)village.func_75567_c() * 0.35);
            if (village.func_75562_e() >= i) continue;
            return true;
        }
        return false;
    }

    public int getSignalStrength() {
        return this.canVillagersBreed() ? 15 : 0;
    }
}

