/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments.flimflams;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.api.IFlimFlamAction;
import openblocks.rubbish.LoreGenerator;
import openmods.utils.ItemUtils;
import openmods.utils.TranslationUtils;
import org.lwjgl.input.Keyboard;

public class LoreFlimFlam
implements IFlimFlamAction {
    public static final String TAG_NAME = "SillyLore";
    public static final String LORE_FORMAT = TextFormatting.GREEN + "" + TextFormatting.ITALIC;

    @Override
    public boolean execute(EntityPlayerMP target) {
        ArrayList slots = Lists.newArrayList((Object[])EntityEquipmentSlot.values());
        Collections.shuffle(slots);
        for (EntityEquipmentSlot slot : slots) {
            if (!LoreFlimFlam.tryAddLore((EntityPlayer)target, slot)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryAddLore(EntityPlayer target, EntityEquipmentSlot slot) {
        ItemStack item = target.func_184582_a(slot);
        if (item == null) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)item);
        NBTTagCompound display = tag.func_74775_l("display");
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)display);
        }
        String lore = LoreGenerator.generateLore(target.func_70005_c_(), LoreFlimFlam.identityType(item));
        NBTTagList loreList = new NBTTagList();
        for (String line : LoreFlimFlam.splitText(lore, 30)) {
            loreList.func_74742_a((NBTBase)new NBTTagString(line));
        }
        display.func_74782_a(TAG_NAME, (NBTBase)loreList);
        return true;
    }

    private static List<String> splitText(String lore, int maxSize) {
        ArrayList result = Lists.newArrayList();
        Joiner joiner = Joiner.on((String)" ");
        Iterable words = Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)lore);
        ArrayList buffer = Lists.newArrayList();
        int length = 0;
        for (String word : words) {
            int newLength = length + word.length();
            if (newLength > maxSize) {
                result.add(joiner.join((Iterable)buffer));
                length = 0;
                buffer.clear();
            }
            buffer.add(word);
            length += word.length() + 1;
        }
        if (!buffer.isEmpty()) {
            result.add(joiner.join((Iterable)buffer));
        }
        return result;
    }

    private static String identityType(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor) {
            switch (((ItemArmor)item).field_77881_a) {
                case HEAD: {
                    return "helmet";
                }
                case CHEST: {
                    return "chestplate";
                }
                case LEGS: {
                    return "leggings";
                }
                case FEET: {
                    return "boots";
                }
            }
        } else {
            if (item instanceof ItemPickaxe) {
                return "pickaxe";
            }
            if (item instanceof ItemShears) {
                return "shears";
            }
            if (item instanceof ItemAxe) {
                return "axe";
            }
            if (item instanceof ItemSpade) {
                return "shovel";
            }
            if (item instanceof ItemBlock) {
                return "block";
            }
            if (item instanceof ItemBucket) {
                return "bucket";
            }
        }
        return "gizmo";
    }

    public static class DisplayHandler {
        @SubscribeEvent
        public void onItemTooltip(ItemTooltipEvent evt) {
            NBTTagCompound displayTag;
            NBTTagCompound itemTag;
            if (Config.loreDisplay > 0 && (itemTag = evt.getItemStack().func_77978_p()) != null && itemTag.func_150297_b("display", 10) && (displayTag = itemTag.func_74775_l("display")).func_150297_b(LoreFlimFlam.TAG_NAME, 9) && !displayTag.func_150297_b("Lore", 9)) {
                NBTTagList sillyLore = displayTag.func_150295_c(LoreFlimFlam.TAG_NAME, 8);
                if (Config.loreDisplay > 1 || Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                    for (int i = 0; i < sillyLore.func_74745_c(); ++i) {
                        evt.getToolTip().add(LORE_FORMAT + sillyLore.func_150307_f(i));
                    }
                } else {
                    evt.getToolTip().add(TranslationUtils.translateToLocal((String)"openblocks.misc.hidden_lore"));
                }
            }
        }
    }
}

