/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.network.NetworkMessage;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.message.MessageChangeControllerSlot;
import vazkii.psi.common.network.message.MessageChangeSocketableSlot;

public class GuiSocketSelect
extends GuiScreen {
    private static final ResourceLocation[] signs = new ResourceLocation[]{new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 0)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 1)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 2)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 3)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 4)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 5)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 6)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 7)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 8)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 9)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 10)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 11)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 12))};
    int timeIn = 0;
    int slotSelected = -1;
    ItemStack controllerStack;
    ISocketableController controller;
    ItemStack[] controlledStacks;
    int controlSlot;
    ItemStack socketableStack;
    ISocketable socketable;
    List<Integer> slots;

    public GuiSocketSelect(ItemStack stack) {
        this.field_146297_k = Minecraft.func_71410_x();
        if (stack.func_77973_b() instanceof ISocketable) {
            this.setSocketable(stack);
        } else if (stack.func_77973_b() instanceof ISocketableController) {
            this.controllerStack = stack;
            this.controller = (ISocketableController)stack.func_77973_b();
            this.controlledStacks = this.controller.getControlledStacks((EntityPlayer)this.field_146297_k.field_71439_g, stack);
            this.controlSlot = this.controller.getDefaultControlSlot(this.controllerStack);
            if (this.controlSlot >= this.controlledStacks.length) {
                this.controlSlot = 0;
            }
            this.setSocketable(this.controlledStacks.length == 0 ? null : this.controlledStacks[this.controlSlot]);
        }
    }

    public void setSocketable(ItemStack stack) {
        this.slots = new ArrayList<Integer>();
        if (stack == null) {
            return;
        }
        this.socketableStack = stack;
        this.socketable = (ISocketable)stack.func_77973_b();
        for (int i = 0; i < 12; ++i) {
            if (!this.socketable.showSlotInRadialMenu(stack, i)) continue;
            this.slots.add(i);
        }
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        super.func_73863_a(mx, my, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        int maxRadius = 80;
        boolean mouseIn = true;
        float angle = GuiSocketSelect.mouseAngle(x, y, mx, my);
        int highlight = 5;
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        int segments = this.slots.size();
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)segments;
        ArrayList<int[]> stringPositions = new ArrayList<int[]>();
        ItemStack cadStack = PsiAPI.getPlayerCAD((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.slotSelected = -1;
        for (int seg = 0; seg < segments; ++seg) {
            boolean mouseInSector = mouseIn && angle > totalDeg && angle < totalDeg + degPer;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            GL11.glBegin((int)6);
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs;
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                if (cadStack != null) {
                    ICAD cad = (ICAD)cadStack.func_77973_b();
                    Color color = new Color(cad.getSpellColor(cadStack));
                    r = (float)color.getRed() / 255.0f;
                    g = (float)color.getGreen() / 255.0f;
                    b = (float)color.getBlue() / 255.0f;
                }
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            GL11.glVertex2i((int)x, (int)y);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if (i == (float)((int)(degPer / 2.0f))) {
                    stringPositions.add(new int[]{seg, (int)xp, (int)yp, mouseInSector ? 110 : 114});
                }
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glVertex2i((int)x, (int)y);
            GL11.glEnd();
            if (!mouseInSector) continue;
            radius -= (float)highlight;
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (int[] pos : stringPositions) {
            int slot = this.slots.get(pos[0]);
            int xp = pos[1];
            int yp = pos[2];
            char c = (char)pos[3];
            ItemStack stack = this.socketable.getBulletInSocket(this.socketableStack, slot);
            if (stack == null) continue;
            int xsp = xp - 4;
            int ysp = yp;
            String name = "\u00a7" + c + stack.func_82833_r();
            int width = this.field_146289_q.func_78256_a(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            this.field_146297_k.func_175599_af().func_175042_a(stack, xdp - 8, ydp - 8);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            this.field_146289_q.func_175063_a(name, (float)xsp, (float)ysp, 0xFFFFFF);
            mod = 0.8;
            xdp = (int)((double)(xp - x) * mod + (double)x);
            ydp = (int)((double)(yp - y) * mod + (double)y);
            this.field_146297_k.field_71446_o.func_110577_a(signs[slot]);
            GuiSocketSelect.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        float s = 3.0f * fract;
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        if (this.controlledStacks != null && this.controlledStacks.length > 0) {
            int xs = this.field_146294_l / 2 - 18 * this.controlledStacks.length / 2;
            int ys = this.field_146295_m / 2;
            for (int i = 0; i < this.controlledStacks.length; ++i) {
                float yoff = 25.0f + (float)maxRadius;
                if (i == this.controlSlot) {
                    yoff += 5.0f;
                }
                GlStateManager.func_179109_b((float)0.0f, (float)(-yoff * fract), (float)0.0f);
                this.field_146297_k.func_175599_af().func_180450_b(this.controlledStacks[i], xs + i * 18, ys);
                GlStateManager.func_179109_b((float)0.0f, (float)(yoff * fract), (float)0.0f);
            }
        }
        if (this.socketableStack != null) {
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            GlStateManager.func_179109_b((float)((float)x / s - 8.0f), (float)((float)y / s - 8.0f), (float)0.0f);
            this.field_146297_k.func_175599_af().func_180450_b(this.socketableStack, 0, 0);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.controllerStack != null && this.controlledStacks.length > 0) {
            if (mouseButton == 0) {
                ++this.controlSlot;
                if (this.controlSlot >= this.controlledStacks.length) {
                    this.controlSlot = 0;
                }
            } else if (mouseButton == 1) {
                --this.controlSlot;
                if (this.controlSlot < 0) {
                    this.controlSlot = this.controlledStacks.length - 1;
                }
            }
            this.setSocketable(this.controlledStacks[this.controlSlot]);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.isKeyDown(KeybindHandler.keybind)) {
            this.field_146297_k.func_147108_a(null);
            if (this.slotSelected != -1) {
                int slot = this.slots.get(this.slotSelected);
                PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g).stopLoopcast();
                NetworkMessage message = null;
                message = this.controllerStack != null ? new MessageChangeControllerSlot(this.controlSlot, slot) : new MessageChangeSocketableSlot(slot);
                NetworkHandler.INSTANCE.sendToServer((IMessage)message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)this.isKeyDown(k));
        }
        ++this.timeIn;
    }

    public boolean isKeyDown(KeyBinding keybind) {
        int key = keybind.func_151463_i();
        if (key < 0) {
            int button = 100 + key;
            return Mouse.isButtonDown((int)button);
        }
        return Keyboard.isKeyDown((int)key);
    }

    public boolean func_73868_f() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }
}

