/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.arl.block.tile.TileMod;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.spell.SpellCompiler;

public class TileProgrammer
extends TileMod {
    private static final String TAG_SPELL = "spell";
    private static final String TAG_PLAYER_LOCK = "playerLock";
    public Spell spell;
    public boolean enabled;
    public String playerLock = "";

    public boolean isEnabled() {
        return this.spell != null && !this.spell.grid.isEmpty();
    }

    public boolean canCompile() {
        return this.isEnabled() && !new SpellCompiler(this.spell).isErrored();
    }

    public void onSpellChanged() {
        boolean wasEnabled = this.enabled;
        this.enabled = this.isEnabled();
        if (wasEnabled != this.enabled) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public void writeSharedNBT(NBTTagCompound cmp) {
        super.writeSharedNBT(cmp);
        NBTTagCompound spellCmp = new NBTTagCompound();
        if (this.spell != null) {
            this.spell.writeToNBT(spellCmp);
        }
        cmp.func_74782_a(TAG_SPELL, (NBTBase)spellCmp);
        cmp.func_74778_a(TAG_PLAYER_LOCK, this.playerLock);
    }

    public void readSharedNBT(NBTTagCompound cmp) {
        super.readSharedNBT(cmp);
        NBTTagCompound spellCmp = cmp.func_74775_l(TAG_SPELL);
        if (this.spell == null) {
            this.spell = Spell.createFromNBT(spellCmp);
        } else {
            this.spell.readFromNBT(spellCmp);
        }
        this.playerLock = cmp.func_74779_i(TAG_PLAYER_LOCK);
    }

    public boolean canPlayerInteract(EntityPlayer player) {
        return !player.field_70128_L && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

