/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.constant;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class PieceConstantNumber
extends SpellPiece {
    private static final String TAG_CONSTANT_VALUE = "constantValue";
    public String valueStr;

    public PieceConstantNumber(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        super.initParams();
        this.valueStr = "0";
    }

    @Override
    public void getShownPieces(List<SpellPiece> pieces) {
        super.getShownPieces(pieces);
    }

    @Override
    public void drawAdditional() {
        if (this.valueStr == null || this.valueStr.isEmpty() || this.valueStr.length() > 5) {
            this.valueStr = "0";
        }
        Minecraft mc = Minecraft.func_71410_x();
        int color = 0xFFFFFF;
        int len = mc.field_71466_p.func_78256_a(this.valueStr);
        float efflen = len;
        float scale = 1.0f;
        while (efflen > 16.0f) {
            efflen = (float)mc.field_71466_p.func_78256_a(this.valueStr) / (scale += 1.0f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
        GlStateManager.func_179109_b((float)((9.0f - efflen / 2.0f) * scale), (float)(4.0f * scale), (float)0.0f);
        mc.field_71466_p.func_78276_b(this.valueStr, 0, 0, color);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean interceptKeystrokes() {
        return true;
    }

    @Override
    public boolean onKeyPressed(char c, int i, boolean doit) {
        if ("FDfd".indexOf(c) >= 0) {
            return false;
        }
        String oldStr = this.valueStr;
        String newStr = this.valueStr;
        if (newStr.equals("0") || newStr.equals("-0")) {
            if (c == '-') {
                newStr = "-0";
            } else if (c != '.') {
                newStr = newStr.replace("0", "");
            }
        }
        if (i == 14) {
            if (newStr.length() == 2 && newStr.startsWith("-")) {
                newStr = "-0";
            } else if (newStr.equals("-")) {
                newStr = "0";
            } else if (!newStr.isEmpty()) {
                newStr = newStr.substring(0, newStr.length() - 1);
            }
        } else if (c != '-') {
            newStr = newStr + c;
        }
        if (newStr.isEmpty()) {
            newStr = "0";
        }
        if ((newStr = newStr.trim()).length() > 5) {
            return false;
        }
        String newValueStr = null;
        try {
            Double.parseDouble(newStr);
            newValueStr = newStr;
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (newValueStr != null && doit) {
            this.valueStr = newValueStr;
        }
        return !newValueStr.equals(oldStr);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        super.writeToNBT(cmp);
        cmp.func_74778_a(TAG_CONSTANT_VALUE, this.valueStr);
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        super.readFromNBT(cmp);
        this.valueStr = cmp.func_74779_i(TAG_CONSTANT_VALUE);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }

    @Override
    public Object evaluate() {
        if (this.valueStr == null || this.valueStr.isEmpty() || this.valueStr.length() > 5) {
            this.valueStr = "0";
        }
        try {
            return Double.parseDouble(this.valueStr);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        return this.evaluate();
    }
}

