/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import net.minecraft.entity.Entity;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public class PieceOperatorClosestToPoint
extends PieceOperator {
    SpellParam position;
    SpellParam list;

    public PieceOperatorClosestToPoint(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
        this.list = new ParamEntityListWrapper("psi.spellparam.target", 13814826, false, false);
        this.addParam(this.list);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        EntityListWrapper listVal = (EntityListWrapper)this.getParamValue(context, this.list);
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        double closest = Double.MAX_VALUE;
        Entity closestEntity = null;
        for (Entity e : listVal) {
            double dist;
            if (e == null || !((dist = MathHelper.pointDistanceSpace(positionVal.x, positionVal.y, positionVal.z, e.field_70165_t, e.field_70163_u, e.field_70161_v)) < closest)) continue;
            closest = dist;
            closestEntity = e;
        }
        if (closestEntity == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return closestEntity;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }
}

