/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.TileConjured;
import vazkii.psi.common.spell.trick.block.PieceTrickPlaceBlock;

public class PieceTrickConjureBlock
extends PieceTrick {
    SpellParam position;
    SpellParam time;

    public PieceTrickConjureBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
        this.time = new ParamNumber("psi.spellparam.time", 0xD22A2A, true, false);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        this.addStats(meta);
    }

    public void addStats(SpellMetadata meta) {
        meta.addStat(EnumSpellStat.POTENCY, 15);
        meta.addStat(EnumSpellStat.COST, 20);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Double timeVal = (Double)this.getParamValue(context, this.time);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = new BlockPos(positionVal.x, positionVal.y, positionVal.z);
        if (!context.caster.field_70170_p.func_175660_a(context.caster, pos)) {
            return null;
        }
        IBlockState state = context.caster.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c() != ModBlocks.conjured) {
            PieceTrickPlaceBlock.placeBlock(context.caster, context.caster.field_70170_p, pos, context.getTargetSlot(), false, true);
            state = context.caster.field_70170_p.func_180495_p(pos);
            if (!context.caster.field_70170_p.field_72995_K && state.func_177230_c() == ModBlocks.conjured) {
                ItemStack cad;
                context.caster.field_70170_p.func_175656_a(pos, this.messWithState(state));
                TileConjured tile = (TileConjured)context.caster.field_70170_p.func_175625_s(pos);
                if (timeVal != null && timeVal.intValue() > 0) {
                    int val;
                    tile.time = val = timeVal.intValue();
                }
                if ((cad = PsiAPI.getPlayerCAD(context.caster)) != null) {
                    tile.colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
                }
            }
        }
        return null;
    }

    public IBlockState messWithState(IBlockState state) {
        return state.func_177226_a((IProperty)BlockConjured.SOLID, (Comparable)Boolean.valueOf(true));
    }
}

